/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.lionfishapi.server.world;

import com.github.L_Ender.lionfishapi.server.registry.LionfishBiomes;
import com.github.L_Ender.lionfishapi.server.world.ModdedBiomeSlice;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public final class ModdedBiomeSource
extends BiomeSource {
    public static final Codec<BiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("original_biome_source").forGetter(thisBiomeSource -> {
        BiomeSource biomeSource;
        if (thisBiomeSource instanceof ModdedBiomeSource) {
            ModdedBiomeSource moddedBiomeSource = (ModdedBiomeSource)((Object)((Object)thisBiomeSource));
            biomeSource = moddedBiomeSource.originalSource;
        } else {
            biomeSource = thisBiomeSource;
        }
        return biomeSource;
    })).apply((Applicative)instance, biomeSource -> biomeSource));
    private final Registry<Biome> biomes;
    private final BiomeSource originalSource;
    private final ThreadLocal<PositionalRandomCache> positionalRandomCache = ThreadLocal.withInitial(PositionalRandomCache::new);
    private final Pair<ResourceLocation, ModdedBiomeSlice>[] slices;
    private final int totalWeight;
    private final int size;
    private final Biome originalSourceMarker;
    private final long slicesSeed;
    private final long slicesZoomSeed;
    private final long obfuscatedSeed;

    public ModdedBiomeSource(Registry<Biome> biomes, BiomeSource originalSource, ArrayList<Pair<ResourceLocation, ModdedBiomeSlice>> slices, int size, long seed, long dimensionSeedModifier) {
        this.biomes = biomes;
        this.originalSource = originalSource;
        this.slices = slices.toArray(new Pair[0]);
        this.totalWeight = Stream.of(this.slices).map(pair -> ((ModdedBiomeSlice)pair.getSecond()).weight()).reduce(0, Integer::sum);
        this.size = size;
        this.originalSourceMarker = (Biome)biomes.m_123013_(LionfishBiomes.ORIGINAL_SOURCE_MARKER);
        this.slicesSeed = seed + 1791510900L + dimensionSeedModifier;
        this.slicesZoomSeed = seed - 771160217L + dimensionSeedModifier;
        this.obfuscatedSeed = BiomeManager.m_47877_((long)seed);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return Stream.concat(this.originalSource.m_207840_().stream(), Arrays.stream(this.slices).flatMap(slice -> ((ModdedBiomeSlice)slice.getSecond()).provider().getAdditionalPossibleBiomes(this.biomes).stream()));
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return (Holder)this.getSlice(x, y, z, sampler, true);
    }

    public void m_207301_(List<String> strings, BlockPos pos, Climate.Sampler sampler) {
        BiomeSource original = this.originalSource;
        original.m_207301_(strings, pos, sampler);
        if (!(original instanceof ModdedBiomeSource)) {
            strings.add("Modded Biome Slice: " + this.getSliceNameVanillaZoom(pos, sampler));
        }
    }

    private <T> T getSlice(int x, int y, int z, Climate.Sampler sampler, boolean returnBiome) {
        Pair[] possibleSlices = new Pair[this.slices.length];
        System.arraycopy(this.slices, 0, possibleSlices, 0, this.slices.length);
        int totalWeight = this.totalWeight;
        long random = this.getPositionalRandom(x, z);
        int randomWeight = Math.floorMod(random, totalWeight);
        int i = 0;
        while (i < possibleSlices.length) {
            ModdedBiomeSlice moddedBiomeSlice;
            Pair slice = possibleSlices[i];
            if (slice != null && (randomWeight -= (moddedBiomeSlice = (ModdedBiomeSlice)slice.getSecond()).weight()) < 0) {
                Holder<Biome> biome = moddedBiomeSlice.provider().getNoiseBiome(x, y, z, sampler, this.originalSource, this.biomes);
                if (biome.m_203334_() == this.originalSourceMarker) {
                    possibleSlices[i] = null;
                    randomWeight = Math.floorMod(random, totalWeight -= moddedBiomeSlice.weight());
                    i = 0;
                    continue;
                }
                return (T)(returnBiome ? biome : slice.getFirst());
            }
            ++i;
        }
        return (T)(returnBiome ? this.originalSource.m_203407_(x, y, z, sampler) : null);
    }

    private long getPositionalRandom(int x, int z) {
        return this.positionalRandomCache.get().getRandom(this, x, z);
    }

    private long computeZoomedPositionalRandom(int x, int z) {
        int cordX = QuartPos.m_175402_((int)x);
        int cordZ = QuartPos.m_175402_((int)z);
        long slicesZoomSeed = this.slicesZoomSeed;
        for (int i = 0; i < this.size; ++i) {
            int cellPosX = cordX & 1;
            int cellPosZ = cordZ & 1;
            int cellX = cordX >> 1;
            int cellZ = cordZ >> 1;
            if (cellPosX == 0 && cellPosZ == 0) {
                cordX = cellX;
                cordZ = cellZ;
                continue;
            }
            if (cellPosX == 0) {
                cordZ = ModdedBiomeSource.nextInt(slicesZoomSeed, cellX << 1, cellZ << 1, 2) == 0 ? cellZ : cordZ + 1 >> 1;
                cordX = cellX;
                continue;
            }
            if (cellPosZ == 0) {
                cordX = ModdedBiomeSource.nextInt(slicesZoomSeed, cellX << 1, cellZ << 1, 2) == 0 ? cellX : cordX + 1 >> 1;
                cordZ = cellZ;
                continue;
            }
            int offsetChoice = ModdedBiomeSource.nextInt(slicesZoomSeed, cellX << 1, cellZ << 1, 4);
            if (offsetChoice == 0) {
                cordX = cellX;
                cordZ = cellZ;
                continue;
            }
            if (offsetChoice == 1) {
                cordX = cordX + 1 >> 1;
                cordZ = cellZ;
                continue;
            }
            if (offsetChoice == 2) {
                cordX = cellX;
                cordZ = cordZ + 1 >> 1;
                continue;
            }
            cordX = cordX + 1 >> 1;
            cordZ = cordZ + 1 >> 1;
        }
        return ModdedBiomeSource.next(this.slicesSeed, cordX, cordZ);
    }

    private static int nextInt(long seed, int x, int z, int bound) {
        return Math.floorMod(ModdedBiomeSource.next(seed, x, z), bound);
    }

    private static long next(long seed, int x, int z) {
        long next = LinearCongruentialGenerator.m_13972_((long)seed, (long)x);
        next = LinearCongruentialGenerator.m_13972_((long)next, (long)z);
        next = LinearCongruentialGenerator.m_13972_((long)next, (long)x);
        return LinearCongruentialGenerator.m_13972_((long)next, (long)z) >> 24;
    }

    @Nullable
    private ResourceLocation getSliceNameVanillaZoom(BlockPos pos, Climate.Sampler sampler) {
        int i = pos.m_123341_() - 2;
        int j = pos.m_123342_() - 2;
        int k = pos.m_123343_() - 2;
        int l = i >> 2;
        int i1 = j >> 2;
        int j1 = k >> 2;
        double d0 = (double)(i & 3) / 4.0;
        double d1 = (double)(j & 3) / 4.0;
        double d2 = (double)(k & 3) / 4.0;
        int k1 = 0;
        double d3 = Double.POSITIVE_INFINITY;
        for (int l1 = 0; l1 < 8; ++l1) {
            double d6;
            double d5;
            double d4;
            boolean flag2;
            int k2;
            boolean flag1;
            int j2;
            boolean flag = (l1 & 4) == 0;
            int i2 = flag ? l : l + 1;
            double d7 = ModdedBiomeSource.getFiddledDistance(this.obfuscatedSeed, i2, j2 = (flag1 = (l1 & 2) == 0) ? i1 : i1 + 1, k2 = (flag2 = (l1 & 1) == 0) ? j1 : j1 + 1, d4 = flag ? d0 : d0 - 1.0, d5 = flag1 ? d1 : d1 - 1.0, d6 = flag2 ? d2 : d2 - 1.0);
            if (!(d3 > d7)) continue;
            k1 = l1;
            d3 = d7;
        }
        int x = (k1 & 4) == 0 ? l : l + 1;
        int y = (k1 & 2) == 0 ? i1 : i1 + 1;
        int z = (k1 & 1) == 0 ? j1 : j1 + 1;
        return (ResourceLocation)this.getSlice(x, y, z, sampler, false);
    }

    private static double getFiddledDistance(long p_186680_, int p_186681_, int p_186682_, int p_186683_, double p_186684_, double p_186685_, double p_186686_) {
        long $$7 = LinearCongruentialGenerator.m_13972_((long)p_186680_, (long)p_186681_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186682_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186683_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186681_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186682_);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186683_);
        double d0 = ModdedBiomeSource.getFiddle($$7);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186680_);
        double d1 = ModdedBiomeSource.getFiddle($$7);
        $$7 = LinearCongruentialGenerator.m_13972_((long)$$7, (long)p_186680_);
        double d2 = ModdedBiomeSource.getFiddle($$7);
        return Mth.m_144952_((double)(p_186686_ + d2)) + Mth.m_144952_((double)(p_186685_ + d1)) + Mth.m_144952_((double)(p_186684_ + d0));
    }

    private static double getFiddle(long p_186690_) {
        double d0 = (double)Math.floorMod(p_186690_ >> 24, 1024) / 1024.0;
        return (d0 - 0.5) * 0.9;
    }

    private static class PositionalRandomCache {
        private final long[] lastXZHashes = new long[256];
        private final long[] randoms;

        private PositionalRandomCache() {
            Arrays.fill(this.lastXZHashes, -9223372036854775807L);
            this.randoms = new long[256];
        }

        private long getRandom(ModdedBiomeSource biomeSource, int x, int z) {
            long xzHash;
            int zIndex;
            int xIndex = SectionPos.m_123207_((int)x);
            int index = 16 * xIndex + (zIndex = SectionPos.m_123207_((int)z));
            if (this.lastXZHashes[index] != (xzHash = ChunkPos.m_45589_((int)x, (int)z))) {
                this.lastXZHashes[index] = xzHash;
                this.randoms[index] = biomeSource.computeZoomedPositionalRandom(x, z);
                return this.randoms[index];
            }
            return this.randoms[index];
        }
    }
}

