/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.pack;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import shcm.shsupercm.fabric.citresewn.CITResewn;
import shcm.shsupercm.fabric.citresewn.cit.CIT;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.cit.CITRegistry;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.core.FallbackCondition;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.core.WeightCondition;
import shcm.shsupercm.fabric.citresewn.pack.GlobalProperties;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public final class PackParser {
    public static final List<String> ROOTS = List.of("mcpatcher", "optifine", "citresewn");

    private PackParser() {
    }

    public static GlobalProperties loadGlobalProperties(ResourceManager resourceManager, GlobalProperties globalProperties) {
        for (PackResources pack : resourceManager.m_7536_().collect(Collectors.toList())) {
            for (String namespace : pack.m_5698_(PackType.CLIENT_RESOURCES)) {
                for (String root : ROOTS) {
                    ResourceLocation identifier = ResourceLocation.m_214293_((String)namespace, (String)(root + "/cit.properties"));
                    try {
                        IoSupplier citPropertiesSupplier = pack.m_214146_(PackType.CLIENT_RESOURCES, identifier);
                        if (citPropertiesSupplier == null) continue;
                        globalProperties.load(pack.m_5542_(), identifier, (InputStream)citPropertiesSupplier.m_247737_());
                    }
                    catch (FileNotFoundException citPropertiesSupplier) {
                    }
                    catch (Exception e) {
                        CITResewn.logErrorLoading("Errored while loading global properties: " + String.valueOf(identifier) + " from " + pack.m_5542_());
                        e.printStackTrace();
                    }
                }
            }
        }
        return globalProperties;
    }

    public static List<CIT<?>> parseCITs(ResourceManager resourceManager) {
        ArrayList cits = new ArrayList();
        for (String root : ROOTS) {
            for (Map.Entry entry : resourceManager.m_214159_(root + "/cit", s -> s.m_135815_().endsWith(".properties")).entrySet()) {
                String packName = null;
                try {
                    packName = ((Resource)entry.getValue()).m_247173_().m_5542_();
                    cits.add(PackParser.parseCIT(PropertyGroup.tryParseGroup(packName, (ResourceLocation)entry.getKey(), ((Resource)entry.getValue()).m_215507_()), resourceManager));
                }
                catch (CITParsingException e) {
                    CITResewn.logErrorLoading(e.getMessage());
                }
                catch (Exception e) {
                    CITResewn.logErrorLoading("Errored while loading cit: " + String.valueOf(entry.getKey()) + (String)(packName == null ? "" : " from " + packName));
                    e.printStackTrace();
                }
            }
        }
        return cits;
    }

    public static CIT<?> parseCIT(PropertyGroup properties, ResourceManager resourceManager) throws CITParsingException {
        CITType citType = CITRegistry.parseType(properties);
        ArrayList<CITCondition> conditions = new ArrayList<CITCondition>();
        Set<PropertyKey> ignoredProperties = citType.typeProperties();
        for (Map.Entry<PropertyKey, Set<PropertyValue>> entry : properties.properties.entrySet()) {
            if (entry.getKey().path().equals("type") && entry.getKey().namespace().equals("citresewn") || ignoredProperties.contains(entry.getKey())) continue;
            for (PropertyValue propertyValue : entry.getValue()) {
                conditions.add(CITRegistry.parseCondition(entry.getKey(), propertyValue, properties));
            }
        }
        for (CITCondition condition2 : new ArrayList(conditions)) {
            if (condition2 == null) continue;
            for (Class clazz : condition2.siblingConditions()) {
                conditions.replaceAll(siblingCondition -> siblingCondition != null && siblingConditionType == siblingCondition.getClass() ? condition2.modifySibling(siblingCondition) : siblingCondition);
            }
        }
        WeightCondition weight = new WeightCondition();
        FallbackCondition fallback = new FallbackCondition();
        conditions.removeIf(condition -> {
            if (condition instanceof WeightCondition) {
                WeightCondition weightCondition = (WeightCondition)condition;
                weight.setWeight(weightCondition.getWeight());
                return true;
            }
            if (condition instanceof FallbackCondition) {
                FallbackCondition fallbackCondition = (FallbackCondition)condition;
                fallback.setFallback(fallbackCondition.getFallback());
                return true;
            }
            return condition == null;
        });
        citType.load(conditions, properties, resourceManager);
        return new CIT<CITType>(properties.identifier, properties.packName, citType, conditions.toArray(new CITCondition[0]), weight.getWeight(), fallback.getFallback());
    }
}

