/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.defaults.cit.types;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.apache.commons.io.IOUtils;
import shcm.shsupercm.fabric.citresewn.CITResewn;
import shcm.shsupercm.fabric.citresewn.api.CITTypeContainer;
import shcm.shsupercm.fabric.citresewn.cit.CIT;
import shcm.shsupercm.fabric.citresewn.cit.CITCache;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.defaults.cit.conditions.ConditionItems;
import shcm.shsupercm.fabric.citresewn.defaults.common.ResewnItemModelIdentifier;
import shcm.shsupercm.fabric.citresewn.defaults.mixin.types.item.JsonUnbakedModelAccessor;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public class TypeItem
extends CITType {
    public static final Container CONTAINER = new Container();
    private static final String GENERATED_SUB_CITS_PREFIX = "sub_cititem_generated_";
    public static final Set<ResourceLocation> GENERATED_SUB_CITS_SEEN = new HashSet<ResourceLocation>();
    private final List<Item> items = new ArrayList<Item>();
    public Map<ResourceLocation, ResourceLocation> assetIdentifiers = new LinkedHashMap<ResourceLocation, ResourceLocation>();
    public Map<List<ItemOverride.Predicate>, BlockModel> unbakedAssets = new LinkedHashMap<List<ItemOverride.Predicate>, BlockModel>();
    private Map<String, Either<Material, String>> textureOverrideMap = new HashMap<String, Either<Material, String>>();
    private boolean isTexture = false;
    public BakedModel bakedModel = null;
    public CITOverrideList bakedSubModels = new CITOverrideList();

    public Set<PropertyKey> typeProperties() {
        return Set.of(PropertyKey.of((String)"model"), PropertyKey.of((String)"texture"), PropertyKey.of((String)"tile"));
    }

    public void load(List<CITCondition> conditions, PropertyGroup properties, ResourceManager resourceManager) throws CITParsingException {
        ResourceLocation assetIdentifier;
        PropertyValue modelProp;
        boolean containsTexture;
        for (CITCondition condition : conditions) {
            if (!(condition instanceof ConditionItems)) continue;
            ConditionItems conditionItems = (ConditionItems)condition;
            this.items.addAll(Arrays.asList(conditionItems.items));
        }
        if (this.items.size() == 0) {
            try {
                ResourceLocation propertiesName = ResourceLocation.m_135820_((String)properties.stripName());
                if (!BuiltInRegistries.f_257033_.m_7804_(propertiesName)) {
                    throw new Exception();
                }
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(propertiesName);
                conditions.add((CITCondition)new ConditionItems(item));
                this.items.add(item);
            }
            catch (Exception ignored) {
                throw new CITParsingException("Not targeting any item type", properties, -1);
            }
        }
        boolean bl = containsTexture = (modelProp = properties.getLastWithoutMetadata("citresewn", new String[]{"model"})) == null && !properties.get("citresewn", new String[]{"texture", "tile"}).isEmpty();
        if (!containsTexture) {
            assetIdentifier = TypeItem.resolveAsset((ResourceLocation)properties.identifier, (PropertyValue)modelProp, (String)"models", (String)".json", (ResourceManager)resourceManager);
            if (assetIdentifier != null) {
                this.assetIdentifiers.put(null, assetIdentifier);
            } else if (modelProp != null && (assetIdentifier = TypeItem.resolveAsset((ResourceLocation)properties.identifier, (PropertyValue)modelProp, (String)"models", (String)".json", (ResourceManager)resourceManager)) != null) {
                this.assetIdentifiers.put(null, assetIdentifier);
            }
        }
        for (PropertyValue property : properties.get("citresewn", new String[]{"model"})) {
            ResourceLocation subIdentifier = TypeItem.resolveAsset((ResourceLocation)properties.identifier, (PropertyValue)property, (String)"models", (String)".json", (ResourceManager)resourceManager);
            if (subIdentifier == null) {
                throw new CITParsingException("Cannot resolve path", properties, property.position());
            }
            String subItem = property.keyMetadata();
            ResourceLocation subItemIdentifier = this.fixDeprecatedSubItem(subItem, properties, property.position());
            this.assetIdentifiers.put(subItemIdentifier == null ? ResourceLocation.m_214293_((String)"minecraft", (String)("item/" + subItem)) : subItemIdentifier, subIdentifier);
        }
        if (this.assetIdentifiers.size() == 0) {
            this.isTexture = true;
            textureProp = properties.getLastWithoutMetadata("citresewn", new String[]{"texture", "tile"});
            assetIdentifier = TypeItem.resolveAsset((ResourceLocation)properties.identifier, (PropertyValue)textureProp, (String)"textures", (String)".png", (ResourceManager)resourceManager);
            if (assetIdentifier != null) {
                this.assetIdentifiers.put(null, assetIdentifier);
            }
            for (PropertyValue property : properties.get("citresewn", new String[]{"texture", "tile"})) {
                if (property.keyMetadata() == null) continue;
                subIdentifier = TypeItem.resolveAsset((ResourceLocation)properties.identifier, (PropertyValue)property, (String)"textures", (String)".png", (ResourceManager)resourceManager);
                if (subIdentifier == null) {
                    throw new CITParsingException("Cannot resolve path", properties, property.position());
                }
                String subItem = property.keyMetadata();
                ResourceLocation subItemIdentifier = this.fixDeprecatedSubItem(subItem, properties, property.position());
                this.assetIdentifiers.put(subItemIdentifier == null ? ResourceLocation.m_214293_((String)"minecraft", (String)("item/" + subItem)) : subItemIdentifier, subIdentifier);
            }
        } else {
            textureProp = properties.getLastWithoutMetadata("citresewn", new String[]{"texture", "tile"});
            if (textureProp != null) {
                assetIdentifier = TypeItem.resolveAsset((ResourceLocation)properties.identifier, (PropertyValue)textureProp, (String)"textures", (String)".png", (ResourceManager)resourceManager);
                if (assetIdentifier != null) {
                    this.textureOverrideMap.put(null, (Either<Material, String>)Either.left((Object)new Material(TextureAtlas.f_118259_, assetIdentifier)));
                } else {
                    throw new CITParsingException("Cannot resolve path", properties, textureProp.position());
                }
            }
            for (PropertyValue property : properties.get("citresewn", new String[]{"texture", "tile"})) {
                textureProp = property;
                subIdentifier = TypeItem.resolveAsset((ResourceLocation)properties.identifier, (PropertyValue)textureProp, (String)"textures", (String)".png", (ResourceManager)resourceManager);
                if (subIdentifier == null) {
                    throw new CITParsingException("Cannot resolve path", properties, property.position());
                }
                this.textureOverrideMap.put(property.keyMetadata(), (Either<Material, String>)Either.left((Object)new Material(TextureAtlas.f_118259_, subIdentifier)));
            }
        }
        if (this.assetIdentifiers.size() == 0) {
            throw new CITParsingException("Could not resolve a replacement model/texture", properties, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUnbakedAssets(ResourceManager resourceManager) throws Exception {
        try {
            if (this.isTexture) {
                ResourceLocation baseIdentifier;
                BlockModel itemJson = this.getModelForFirstItemType(resourceManager);
                if (((JsonUnbakedModelAccessor)itemJson).getTextureMap().size() > 1) {
                    this.textureOverrideMap = ((JsonUnbakedModelAccessor)itemJson).getTextureMap();
                    ResourceLocation defaultAsset = this.assetIdentifiers.get(null);
                    this.textureOverrideMap.replaceAll((layerName, originalTextureEither) -> {
                        ResourceLocation textureIdentifier = this.assetIdentifiers.remove(originalTextureEither.map(Material::m_119203_, ResourceLocation::m_135820_));
                        if (textureIdentifier != null) {
                            return Either.left((Object)new Material(TextureAtlas.f_118259_, textureIdentifier));
                        }
                        if (defaultAsset != null) {
                            return Either.left((Object)new Material(TextureAtlas.f_118259_, defaultAsset));
                        }
                        return null;
                    });
                    if (this.assetIdentifiers.size() == 0 || this.assetIdentifiers.size() == 1 && this.assetIdentifiers.containsKey(null)) {
                        this.unbakedAssets.put(null, itemJson);
                        return;
                    }
                }
                if ((baseIdentifier = this.assetIdentifiers.remove(null)) != null) {
                    this.unbakedAssets.put(null, this.loadUnbakedAsset(resourceManager, baseIdentifier, null));
                    if (this.items.contains(Items.f_220219_) && !this.assetIdentifiers.containsKey(ResourceLocation.m_214293_((String)"minecraft", (String)"item/tooting_goat_horn"))) {
                        this.assetIdentifiers.put(ResourceLocation.m_214293_((String)"minecraft", (String)"item/tooting_goat_horn"), baseIdentifier);
                    }
                }
                if (!this.assetIdentifiers.isEmpty()) {
                    LinkedHashMap overrideConditions = new LinkedHashMap();
                    for (Item item : this.items) {
                        ResourceLocation itemIdentifier = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                        overrideConditions.put(ResourceLocation.m_214293_((String)itemIdentifier.m_135827_(), (String)("item/" + itemIdentifier.m_135815_())), Collections.emptyList());
                        ResourceLocation itemModelIdentifier = ResourceLocation.m_214293_((String)itemIdentifier.m_135827_(), (String)("models/item/" + itemIdentifier.m_135815_() + ".json"));
                        try (InputStreamReader resourceReader = new InputStreamReader(((Resource)resourceManager.m_213713_(itemModelIdentifier).orElseThrow()).m_215507_());){
                            BlockModel itemModelJson = BlockModel.m_111461_((Reader)resourceReader);
                            if (itemModelJson.m_111484_() == null || itemModelJson.m_111484_().isEmpty()) continue;
                            for (ItemOverride override : itemModelJson.m_111484_()) {
                                overrideConditions.put(override.m_111718_(), override.m_173449_().toList());
                            }
                        }
                    }
                    ArrayList overrideModels = new ArrayList(overrideConditions.keySet());
                    Collections.reverse(overrideModels);
                    for (ResourceLocation overrideModel : overrideModels) {
                        ResourceLocation replacement = this.assetIdentifiers.remove(overrideModel);
                        if (replacement == null) continue;
                        List conditions = (List)overrideConditions.get(overrideModel);
                        if (overrideModel != null) {
                            GENERATED_SUB_CITS_SEEN.add(replacement);
                            replacement = ResourceLocation.m_214293_((String)replacement.m_135827_(), (String)(GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + replacement.m_135815_()));
                        }
                        this.unbakedAssets.put(conditions, this.loadUnbakedAsset(resourceManager, replacement, overrideModel));
                    }
                }
            } else {
                ResourceLocation baseIdentifier = this.assetIdentifiers.remove(null);
                if (baseIdentifier != null) {
                    if (!GENERATED_SUB_CITS_SEEN.add(baseIdentifier)) {
                        baseIdentifier = ResourceLocation.m_214293_((String)baseIdentifier.m_135827_(), (String)(GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + baseIdentifier.m_135815_()));
                    }
                    GENERATED_SUB_CITS_SEEN.add(baseIdentifier);
                    BlockModel model = this.loadUnbakedAsset(resourceManager, baseIdentifier, null);
                    this.unbakedAssets.put(null, model);
                    if (model.m_111484_().size() > 0 && this.textureOverrideMap.size() > 0) {
                        LinkedHashMap overrideConditions = new LinkedHashMap();
                        for (ItemOverride itemOverride : model.m_111484_()) {
                            overrideConditions.put(itemOverride.m_111718_(), itemOverride.m_173449_().toList());
                        }
                        ArrayList overrideModels = new ArrayList(overrideConditions.keySet());
                        Collections.reverse(overrideModels);
                        Iterator iterator = overrideModels.iterator();
                        while (iterator.hasNext()) {
                            ResourceLocation overrideModel = (ResourceLocation)iterator.next();
                            ResourceLocation replacement = TypeItem.resolveAsset((ResourceLocation)baseIdentifier, (String)overrideModel.toString(), (String)"models", (String)".json", (ResourceManager)resourceManager);
                            if (replacement == null) continue;
                            String subTexturePath = replacement.toString().substring(0, replacement.toString().lastIndexOf(46));
                            String subTextureName = subTexturePath.substring(subTexturePath.lastIndexOf(47) + 1);
                            replacement = baseIdentifier;
                            if (!GENERATED_SUB_CITS_SEEN.add(replacement)) {
                                replacement = ResourceLocation.m_214293_((String)replacement.m_135827_(), (String)(GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + replacement.m_135815_()));
                            }
                            GENERATED_SUB_CITS_SEEN.add(replacement);
                            BlockModel jsonModel = this.loadUnbakedAsset(resourceManager, replacement, null);
                            jsonModel.m_111484_().clear();
                            ((JsonUnbakedModelAccessor)jsonModel).getTextureMap().replaceAll((layerName, texture) -> {
                                if (layerName != null) {
                                    try {
                                        for (String subTexture : this.textureOverrideMap.keySet()) {
                                            if (!subTextureName.equals(subTexture)) continue;
                                            return this.textureOverrideMap.get(subTexture);
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                return texture;
                            });
                            this.unbakedAssets.put((List)overrideConditions.get(overrideModel), jsonModel);
                        }
                    }
                }
                if (!this.assetIdentifiers.isEmpty()) {
                    LinkedHashMap overrideConditions = new LinkedHashMap();
                    for (Item item : this.items) {
                        ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_((Object)item);
                        overrideConditions.put(ResourceLocation.m_214293_((String)resourceLocation.m_135827_(), (String)("item/" + resourceLocation.m_135815_())), Collections.emptyList());
                        ResourceLocation itemModelIdentifier = ResourceLocation.m_214293_((String)resourceLocation.m_135827_(), (String)("models/item/" + resourceLocation.m_135815_() + ".json"));
                        try (InputStreamReader resourceReader = new InputStreamReader(((Resource)resourceManager.m_213713_(itemModelIdentifier).orElseThrow()).m_215507_());){
                            BlockModel itemModelJson = BlockModel.m_111461_((Reader)resourceReader);
                            if (itemModelJson.m_111484_() == null || itemModelJson.m_111484_().isEmpty()) continue;
                            for (ItemOverride override : itemModelJson.m_111484_()) {
                                overrideConditions.put(override.m_111718_(), override.m_173449_().toList());
                            }
                        }
                    }
                    ArrayList overrideModels = new ArrayList(overrideConditions.keySet());
                    Collections.reverse(overrideModels);
                    for (ResourceLocation resourceLocation : overrideModels) {
                        ResourceLocation replacement = this.assetIdentifiers.remove(resourceLocation);
                        if (replacement == null) continue;
                        if (!GENERATED_SUB_CITS_SEEN.add(replacement)) {
                            replacement = ResourceLocation.m_214293_((String)replacement.m_135827_(), (String)(GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + replacement.m_135815_()));
                        }
                        GENERATED_SUB_CITS_SEEN.add(replacement);
                        List conditions = (List)overrideConditions.get(resourceLocation);
                        this.unbakedAssets.put(conditions, this.loadUnbakedAsset(resourceManager, replacement, null));
                    }
                }
            }
        }
        finally {
            this.assetIdentifiers = null;
            this.textureOverrideMap = null;
        }
    }

    private BlockModel loadUnbakedAsset(ResourceManager resourceManager, ResourceLocation assetIdentifier, ResourceLocation overrideModel) throws Exception {
        BlockModel json;
        ResourceLocation possibleIdentifier = assetIdentifier;
        while (possibleIdentifier.m_135815_().startsWith(GENERATED_SUB_CITS_PREFIX)) {
            possibleIdentifier = ResourceLocation.m_214293_((String)possibleIdentifier.m_135827_(), (String)possibleIdentifier.m_135815_().substring(possibleIdentifier.m_135815_().substring(GENERATED_SUB_CITS_PREFIX.length()).indexOf(95) + GENERATED_SUB_CITS_PREFIX.length() + 1));
        }
        ResourceLocation identifier = possibleIdentifier;
        if (identifier.m_135815_().endsWith(".json")) {
            try (InputStream is = ((Resource)resourceManager.m_213713_(identifier).orElseThrow()).m_215507_();){
                ResourceLocation parentId;
                json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                json.f_111416_ = assetIdentifier.toString();
                json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
                ((JsonUnbakedModelAccessor)json).getTextureMap().replaceAll((layer, original) -> {
                    ResourceLocation resolvedIdentifier;
                    Optional left = original.left();
                    if (left.isPresent() && (resolvedIdentifier = TypeItem.resolveAsset((ResourceLocation)identifier, (String)((Material)left.get()).m_119203_().m_135815_(), (String)"textures", (String)".png", (ResourceManager)resourceManager)) != null) {
                        return Either.left((Object)new Material(((Material)left.get()).m_119193_(), resolvedIdentifier));
                    }
                    return original;
                });
                if (this.textureOverrideMap.size() > 0) {
                    Either<Material, String> defaultTextureOverride;
                    Map<String, Either<Material, String>> jsonTextureMap = ((JsonUnbakedModelAccessor)json).getTextureMap();
                    if (jsonTextureMap.size() == 0) {
                        jsonTextureMap.put("layer0", null);
                    }
                    if ((defaultTextureOverride = this.textureOverrideMap.get(null)) != null) {
                        jsonTextureMap.replaceAll((layerName, spriteIdentifierStringEither) -> defaultTextureOverride);
                    }
                    jsonTextureMap.replaceAll((layerName, texture) -> {
                        if (layerName != null) {
                            try {
                                String[] split = ((String)texture.map(id -> id.m_119203_().m_135815_(), s -> s)).split("/");
                                String textureName = split[split.length - 1];
                                if (textureName.endsWith(".png")) {
                                    textureName = textureName.substring(0, textureName.length() - 4);
                                }
                                return Objects.requireNonNull(this.textureOverrideMap.get(textureName));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return texture;
                    });
                    jsonTextureMap.values().removeIf(Objects::isNull);
                }
                if ((parentId = ((JsonUnbakedModelAccessor)json).getParentId()) != null) {
                    String[] parentIdPathSplit = parentId.m_135815_().split("/");
                    if ((parentId.m_135815_().startsWith("./") || parentIdPathSplit.length > 2 && parentIdPathSplit[1].equals("cit")) && (parentId = TypeItem.resolveAsset((ResourceLocation)identifier, (String)parentId.m_135815_(), (String)"models", (String)".json", (ResourceManager)resourceManager)) != null) {
                        ((JsonUnbakedModelAccessor)json).setParentId(ResewnItemModelIdentifier.pack(parentId));
                    }
                }
                json.m_111484_().replaceAll(override -> {
                    ResourceLocation resolvedOverridePath;
                    String[] modelIdPathSplit = override.m_111718_().m_135815_().split("/");
                    if ((override.m_111718_().m_135815_().startsWith("./") || modelIdPathSplit.length > 2 && modelIdPathSplit[1].equals("cit")) && (resolvedOverridePath = TypeItem.resolveAsset((ResourceLocation)identifier, (String)override.m_111718_().m_135815_(), (String)"models", (String)".json", (ResourceManager)resourceManager)) != null) {
                        return new ItemOverride(ResewnItemModelIdentifier.pack(resolvedOverridePath), override.m_173449_().collect(Collectors.toList()));
                    }
                    return override;
                });
                BlockModel blockModel = json;
                return blockModel;
            }
        }
        if (identifier.m_135815_().endsWith(".png")) {
            BlockModel blockModel = json = overrideModel == null ? this.getModelForFirstItemType(resourceManager) : this.getModelFromOverrideModel(resourceManager, overrideModel);
            if (json == null) {
                json = new BlockModel(ResourceLocation.m_214293_((String)"minecraft", (String)"item/generated"), new ArrayList(), (Map)ImmutableMap.of((Object)"layer0", (Object)Either.left((Object)new Material(TextureAtlas.f_118259_, identifier))), Boolean.valueOf(true), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
            }
            json.m_111484_().clear();
            json.f_111416_ = assetIdentifier.toString();
            json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 4);
            ((JsonUnbakedModelAccessor)json).getTextureMap().replaceAll((layerName, originalTextureEither) -> {
                if (this.textureOverrideMap.size() > 0) {
                    Either<Material, String> textureOverride = this.textureOverrideMap.get(layerName);
                    if (textureOverride == null) {
                        textureOverride = this.textureOverrideMap.get(null);
                    }
                    return textureOverride == null ? originalTextureEither : textureOverride;
                }
                return Either.left((Object)new Material(TextureAtlas.f_118259_, identifier));
            });
            return json;
        }
        throw new Exception("Unknown asset type");
    }

    public ResourceLocation fixDeprecatedSubItem(String subItem, PropertyGroup properties, int position) {
        String replacement;
        if (subItem == null) {
            return null;
        }
        switch (subItem) {
            case "bow_standby": {
                String string = "bow";
                break;
            }
            case "crossbow_standby": {
                String string = "crossbow";
                break;
            }
            case "potion_bottle_drinkable": {
                String string = "potion";
                break;
            }
            case "potion_bottle_splash": {
                String string = "splash_potion";
                break;
            }
            case "potion_bottle_lingering": {
                String string = "lingering_potion";
                break;
            }
            default: {
                String string = replacement = null;
            }
        }
        if (replacement != null) {
            CITResewn.logWarnLoading((String)properties.messageWithDescriptorOf("Warning: Using deprecated sub item id \"" + subItem + "\" instead of \"" + replacement + "\"", position));
            return ResourceLocation.m_214293_((String)"minecraft", (String)("item/" + replacement));
        }
        return null;
    }

    private BlockModel getModelForFirstItemType(ResourceManager resourceManager) {
        BlockModel blockModel;
        block17: {
            ResourceLocation firstItemIdentifier = BuiltInRegistries.f_257033_.m_7981_((Object)this.items.iterator().next());
            ResourceLocation firstItemModelIdentifier = ResourceLocation.m_214293_((String)firstItemIdentifier.m_135827_(), (String)("models/item/" + firstItemIdentifier.m_135815_() + ".json"));
            InputStream is = ((Resource)resourceManager.m_213713_(firstItemModelIdentifier).orElseThrow()).m_215507_();
            try {
                BlockModel json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                if (((JsonUnbakedModelAccessor)json).getParentId().equals((Object)ResourceLocation.m_214293_((String)"minecraft", (String)"item/template_spawn_egg"))) {
                    try (InputStream parentInputStream = ((Resource)resourceManager.m_213713_(ResourceLocation.m_214293_((String)"minecraft", (String)"models/item/template_spawn_egg.json")).orElseThrow()).m_215507_();){
                        json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)parentInputStream, (Charset)StandardCharsets.UTF_8));
                        ((JsonUnbakedModelAccessor)json).getTextureMap().remove("layer1");
                    }
                }
                if (!GENERATED_SUB_CITS_SEEN.add(firstItemModelIdentifier)) {
                    firstItemModelIdentifier = ResourceLocation.m_214293_((String)firstItemModelIdentifier.m_135827_(), (String)(GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + firstItemModelIdentifier.m_135815_()));
                }
                GENERATED_SUB_CITS_SEEN.add(firstItemModelIdentifier);
                json.f_111416_ = firstItemModelIdentifier.toString();
                json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
                blockModel = json;
                if (is == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return blockModel;
    }

    private BlockModel getModelFromOverrideModel(ResourceManager resourceManager, ResourceLocation overrideModel) {
        BlockModel blockModel;
        block9: {
            ResourceLocation modelIdentifier = ResourceLocation.m_214293_((String)overrideModel.m_135827_(), (String)("models/" + overrideModel.m_135815_() + ".json"));
            InputStream is = ((Resource)resourceManager.m_213713_(modelIdentifier).orElseThrow()).m_215507_();
            try {
                BlockModel json = BlockModel.m_111463_((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                if (!GENERATED_SUB_CITS_SEEN.add(modelIdentifier)) {
                    modelIdentifier = ResourceLocation.m_214293_((String)modelIdentifier.m_135827_(), (String)(GENERATED_SUB_CITS_PREFIX + GENERATED_SUB_CITS_SEEN.size() + "_" + modelIdentifier.m_135815_()));
                }
                GENERATED_SUB_CITS_SEEN.add(modelIdentifier);
                json.f_111416_ = modelIdentifier.toString();
                json.f_111416_ = json.f_111416_.substring(0, json.f_111416_.length() - 5);
                blockModel = json;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return null;
                }
            }
            is.close();
        }
        return blockModel;
    }

    public BakedModel getItemModel(CITContext context, int seed) {
        ClientLevel clientWorld;
        Level level = context.world;
        ClientLevel world = level instanceof ClientLevel ? (clientWorld = (ClientLevel)level) : null;
        BakedModel bakedModel = this.bakedSubModels.m_173464_(this.bakedModel, context.stack, world, context.entity, seed);
        if (bakedModel != null && bakedModel.m_7343_() != null) {
            bakedModel = bakedModel.m_7343_().m_173464_(bakedModel, context.stack, world, context.entity, seed);
        }
        return bakedModel;
    }

    public static class CITOverrideList
    extends ItemOverrides {
        public void override(List<ItemOverride.Predicate> key, BakedModel bakedModel) {
            LinkedHashSet<ResourceLocation> conditionTypes = new LinkedHashSet<ResourceLocation>(Arrays.asList(this.f_173461_));
            for (ItemOverride.Predicate condition : key) {
                conditionTypes.add(condition.m_173459_());
            }
            this.f_173461_ = conditionTypes.toArray(new ResourceLocation[0]);
            this.f_111735_ = Arrays.copyOf(this.f_111735_, this.f_111735_.length + 1);
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            for (int i = 0; i < this.f_173461_.length; ++i) {
                object2IntMap.put((Object)this.f_173461_[i], i);
            }
            this.f_111735_[this.f_111735_.length - 1] = new ItemOverrides.BakedOverride((ItemOverrides.PropertyMatcher[])key.stream().map(arg_0 -> CITOverrideList.lambda$override$0((Object2IntMap)object2IntMap, arg_0)).toArray(ItemOverrides.PropertyMatcher[]::new), bakedModel);
        }

        private static /* synthetic */ ItemOverrides.PropertyMatcher lambda$override$0(Object2IntMap object2IntMap, ItemOverride.Predicate condition) {
            return new ItemOverrides.PropertyMatcher(object2IntMap.getInt((Object)condition.m_173459_()), condition.m_173460_());
        }
    }

    public static class Container
    extends CITTypeContainer<TypeItem> {
        public Set<CIT<TypeItem>> loaded = new HashSet<CIT<TypeItem>>();
        public Map<Item, Set<CIT<TypeItem>>> loadedTyped = new IdentityHashMap<Item, Set<CIT<TypeItem>>>();

        public Container() {
            super(TypeItem.class, TypeItem::new, "item");
        }

        public void load(List<CIT<TypeItem>> parsedCITs) {
            this.loaded.addAll(parsedCITs);
            for (CIT<TypeItem> cit : parsedCITs) {
                for (CITCondition condition : cit.conditions) {
                    if (!(condition instanceof ConditionItems)) continue;
                    ConditionItems items = (ConditionItems)condition;
                    for (Item item : items.items) {
                        if (item == null) continue;
                        this.loadedTyped.computeIfAbsent(item, i -> new LinkedHashSet()).add(cit);
                    }
                }
            }
        }

        public void dispose() {
            this.loaded.clear();
            this.loadedTyped.clear();
        }

        public CIT<TypeItem> getCIT(CITContext context, int seed) {
            return (CIT)((CITCacheItem)context.stack).citresewn$getCacheTypeItem().get(context).get();
        }

        public CIT<TypeItem> getRealTimeCIT(CITContext context) {
            Set<CIT<TypeItem>> loadedForItemType = this.loadedTyped.get(context.stack.m_41720_());
            if (loadedForItemType != null) {
                for (CIT<TypeItem> cit : loadedForItemType) {
                    if (!cit.test(context)) continue;
                    return cit;
                }
            }
            return null;
        }
    }

    public static interface BakedModelManagerMixinAccess {
        public void citresewn$forceMojankModel(BakedModel var1);
    }

    public static interface CITCacheItem {
        public CITCache.Single<TypeItem> citresewn$getCacheTypeItem();
    }
}

