/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;

public class DynamicResourcePack
implements PackResources {
    private final String packName;
    private Map<DynamicResourceKey, IoSupplier<InputStream>> dynamicResourceMap = new HashMap<DynamicResourceKey, IoSupplier<InputStream>>();

    public DynamicResourcePack(String packName) {
        this.packName = packName;
    }

    public void clear() {
        this.dynamicResourceMap.clear();
    }

    public boolean removeResource(PackType type, ResourceLocation location) {
        DynamicResourceKey key = new DynamicResourceKey(type.m_10305_(), location.m_135827_(), location.m_135815_());
        if (this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.remove(key);
            return true;
        }
        return false;
    }

    public boolean registerResource(PackType type, ResourceLocation location, IoSupplier<InputStream> resourceSupplier) {
        return this.register(type.m_10305_(), location.m_135827_(), location.m_135815_(), resourceSupplier);
    }

    public boolean registerRootResource(String path, IoSupplier<InputStream> resourceSupplier) {
        return this.register("root", "", path, resourceSupplier);
    }

    private boolean register(String directory, String namespace, String path, IoSupplier<InputStream> resourceSupplier) {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (!this.dynamicResourceMap.containsKey(key)) {
            this.dynamicResourceMap.put(key, resourceSupplier);
            return true;
        }
        return false;
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... path) {
        try {
            return this.getResource("root", "", String.join((CharSequence)"/", path));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        try {
            return this.getResource(type.m_10305_(), location.m_135827_(), location.m_135815_());
        }
        catch (IOException e) {
            return null;
        }
    }

    private IoSupplier<InputStream> getResource(String directory, String namespace, String path) throws IOException {
        DynamicResourceKey key = new DynamicResourceKey(directory, namespace, path);
        if (this.dynamicResourceMap.containsKey(key)) {
            return this.dynamicResourceMap.get(key);
        }
        throw new FileNotFoundException("Can't find dynamic resource " + path + ". Please ensure it has been registered.");
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        this.dynamicResourceMap.entrySet().stream().filter(entry -> ((DynamicResourceKey)entry.getKey()).namespace.contentEquals(namespace)).filter(entry -> ((DynamicResourceKey)entry.getKey()).path.startsWith(path)).filter(entry -> ((DynamicResourceKey)entry.getKey()).type.contentEquals(type.m_10305_())).forEach(entry -> output.accept((Object)new ResourceLocation(namespace, ((DynamicResourceKey)entry.getKey()).path), (Object)((IoSupplier)entry.getValue())));
    }

    public Set<String> m_5698_(PackType type) {
        HashSet<String> namespaces = new HashSet<String>();
        for (DynamicResourceKey key : this.dynamicResourceMap.keySet()) {
            if (!type.m_10305_().contentEquals(key.type)) continue;
            namespaces.add(key.namespace);
        }
        return namespaces;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> p_10291_) throws IOException {
        return null;
    }

    public String m_5542_() {
        return this.packName;
    }

    public void close() {
    }

    private record DynamicResourceKey(String type, String namespace, String path) {
    }
}

