/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.level.IKeyedClientLevelManager;
import com.seibel.distanthorizons.core.level.IServerKeyedClientLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.ClientBlockStateColorCache;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientLevelWrapper
implements IClientLevelWrapper {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Map<class_638, WeakReference<ClientLevelWrapper>> LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL = Collections.synchronizedMap(new WeakHashMap());
    private static final IKeyedClientLevelManager KEYED_CLIENT_LEVEL_MANAGER = SingletonInjector.INSTANCE.get(IKeyedClientLevelManager.class);
    private static final class_310 MINECRAFT = class_310.method_1551();
    private final class_638 level;
    private final ConcurrentHashMap<class_2680, ClientBlockStateColorCache> blockColorCacheByBlockState = new ConcurrentHashMap();
    private final Function<class_2680, ClientBlockStateColorCache> createCachedBlockColorCacheFunc = blockState -> new ClientBlockStateColorCache((class_2680)blockState, this);
    private BlockStateWrapper dirtBlockWrapper;
    private IDhLevel dhLevel;

    protected ClientLevelWrapper(class_638 level) {
        this.level = level;
    }

    @Nullable
    public static IClientLevelWrapper getWrapperIfDifferent(@Nullable IClientLevelWrapper levelWrapper, @NotNull class_638 level) {
        if (KEYED_CLIENT_LEVEL_MANAGER.isEnabled() && KEYED_CLIENT_LEVEL_MANAGER.getServerKeyedLevel() != levelWrapper) {
            return ClientLevelWrapper.getWrapper(level);
        }
        ClientLevelWrapper clientLevelWrapper = (ClientLevelWrapper)levelWrapper;
        if (clientLevelWrapper == null || clientLevelWrapper.level != level) {
            return ClientLevelWrapper.getWrapper(level);
        }
        return clientLevelWrapper;
    }

    @Nullable
    public static IClientLevelWrapper getWrapper(@NotNull class_638 level) {
        return ClientLevelWrapper.getWrapper(level, false);
    }

    @Nullable
    public static IClientLevelWrapper getWrapper(@Nullable class_638 level, boolean bypassLevelKeyManager) {
        ClientLevelWrapper levelWrapper;
        WeakReference<ClientLevelWrapper> levelRef;
        if (!bypassLevelKeyManager) {
            if (level == null) {
                return null;
            }
            IServerKeyedClientLevel overrideLevel = KEYED_CLIENT_LEVEL_MANAGER.getServerKeyedLevel();
            if (overrideLevel != null) {
                return overrideLevel;
            }
        }
        if ((levelRef = LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.get(level)) != null && (levelWrapper = (ClientLevelWrapper)levelRef.get()) != null) {
            return levelWrapper;
        }
        return (IClientLevelWrapper)LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.compute(level, (newLevel, newLevelRef) -> {
            ClientLevelWrapper oldLevelWrapper;
            if (newLevelRef != null && (oldLevelWrapper = (ClientLevelWrapper)newLevelRef.get()) != null) {
                return newLevelRef;
            }
            return new WeakReference<ClientLevelWrapper>(new ClientLevelWrapper((class_638)newLevel));
        }).get();
    }

    @Override
    @Nullable
    public IServerLevelWrapper tryGetServerSideWrapper() {
        try {
            if (MINECRAFT.method_1576() == null) {
                return null;
            }
            Iterable serverLevels = MINECRAFT.method_1576().method_3738();
            ServerLevelWrapper foundLevelWrapper = null;
            for (class_3218 serverLevel : serverLevels) {
                if (serverLevel.method_27983() != this.level.method_27983()) continue;
                foundLevelWrapper = ServerLevelWrapper.getWrapper(serverLevel);
                break;
            }
            return foundLevelWrapper;
        }
        catch (Exception e) {
            LOGGER.error("Failed to get server side wrapper for client level: " + String.valueOf(this.level), new Object[0]);
            return null;
        }
    }

    @Override
    public int getBlockColor(DhBlockPos blockPos, IBiomeWrapper biome, FullDataSourceV2 fullDataSource, IBlockStateWrapper blockWrapper) {
        ClientBlockStateColorCache blockColorCache = this.blockColorCacheByBlockState.get(((BlockStateWrapper)blockWrapper).blockState);
        if (blockColorCache == null) {
            blockColorCache = this.blockColorCacheByBlockState.computeIfAbsent(((BlockStateWrapper)blockWrapper).blockState, this.createCachedBlockColorCacheFunc);
        }
        return blockColorCache.getColor((BiomeWrapper)biome, fullDataSource, blockPos);
    }

    @Override
    public int getDirtBlockColor() {
        if (this.dirtBlockWrapper == null) {
            try {
                this.dirtBlockWrapper = (BlockStateWrapper)BlockStateWrapper.deserialize("minecraft:dirt", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get dirt color with resource location [minecraft:dirt] with level [" + String.valueOf(this) + "].", e);
                return -1;
            }
        }
        return this.getBlockColor(DhBlockPos.ZERO, BiomeWrapper.EMPTY_WRAPPER, null, this.dirtBlockWrapper);
    }

    @Override
    public void clearBlockColorCache() {
        this.blockColorCacheByBlockState.clear();
    }

    @Override
    public IDimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.method_8597());
    }

    @Override
    public String getDimensionName() {
        return this.level.method_27983().method_29177().toString();
    }

    @Override
    public long getHashedSeed() {
        return this.level.method_22385().field_20641;
    }

    @Override
    public String getDhIdentifier() {
        return this.getHashedSeedEncoded() + "@" + this.getDimensionName();
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.CLIENT_LEVEL;
    }

    public class_638 getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.method_8597().comp_643();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.method_8597().comp_642();
    }

    @Override
    public int getMaxHeight() {
        return this.level.method_31605();
    }

    @Override
    public int getMinHeight() {
        return this.level.method_31607();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.method_8393(pos.getX(), pos.getZ())) {
            return null;
        }
        class_2791 chunk = this.level.method_8402(pos.getX(), pos.getZ(), class_2806.field_12798, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, this);
    }

    public class_638 getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_REF_BY_CLIENT_LEVEL.remove(this.level);
        this.dhLevel = null;
    }

    @Override
    public File getDhSaveFolder() {
        if (this.dhLevel == null) {
            return null;
        }
        return this.dhLevel.getSaveStructure().getSaveFolder(this);
    }

    @Override
    public void setDhLevel(IDhLevel dhLevel) {
        this.dhLevel = dhLevel;
    }

    @Override
    public IDhLevel getDhLevel() {
        return this.dhLevel;
    }

    @Override
    public IDhApiCustomRenderRegister getRenderRegister() {
        if (this.dhLevel == null) {
            return null;
        }
        return this.dhLevel.getGenericRenderer();
    }

    @Override
    public Color getCloudColor(float tickDelta) {
        class_243 colorVec3 = this.level.method_23785(tickDelta);
        return new Color((float)colorVec3.field_1352, (float)colorVec3.field_1351, (float)colorVec3.field_1350);
    }

    public String toString() {
        if (this.level == null) {
            return "Wrapped{null}";
        }
        return "Wrapped{" + this.level.toString() + "@" + this.getDhIdentifier() + "}";
    }
}

