/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.ExceptionUtil;
import com.seibel.distanthorizons.core.util.TimerUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IC2meAccessor;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.ChunkPosGenStream;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.GenerationEvent;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.params.GlobalWorldGenParams;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3230;

public class InternalServerGenerator {
    public static final DhLogger LOGGER = new DhLoggerBuilder().name("LOD World Gen - Internal Server").fileLevelConfig(Config.Common.Logging.logWorldGenEventToFile).build();
    public static final DhLogger CHUNK_LOAD_LOGGER = new DhLoggerBuilder().name("LOD Chunk Loading").fileLevelConfig(Config.Common.Logging.logWorldGenChunkLoadEventToFile).build();
    private static final IC2meAccessor C2ME_ACCESSOR = ModAccessorInjector.INSTANCE.get(IC2meAccessor.class);
    private static final int MS_TO_IGNORE_CHUNK_AFTER_COMPLETION = 5000;
    private static final class_3230<class_1923> DH_SERVER_GEN_TICKET = class_3230.method_14291((String)"dh_server_gen_ticket", Comparator.comparingLong(class_1923::method_8324));
    private static boolean c2meMissingWarningLogged = false;
    private final GlobalWorldGenParams params;
    private final IDhServerLevel dhServerLevel;
    private final Timer chunkSaveIgnoreTimer = TimerUtil.CreateTimer("ChunkSaveIgnoreTimer");

    public InternalServerGenerator(GlobalWorldGenParams params, IDhServerLevel dhServerLevel) {
        this.params = params;
        this.dhServerLevel = dhServerLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateChunksViaInternalServer(GenerationEvent genEvent) {
        this.runValidation();
        try {
            ArrayList<CompletionStage> getChunkFutureList = new ArrayList<CompletionStage>();
            Iterator<class_1923> chunkPosIterator = ChunkPosGenStream.getIterator(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.widthInChunks, 0);
            while (chunkPosIterator.hasNext()) {
                class_1923 chunkPos = chunkPosIterator.next();
                CompletionStage requestChunkFuture = this.requestChunkFromServerAsync(chunkPos).whenCompleteAsync((chunk, throwable) -> {
                    Throwable actualThrowable = throwable;
                    while (actualThrowable instanceof CompletionException) {
                        actualThrowable = actualThrowable.getCause();
                    }
                    if (actualThrowable != null) {
                        boolean isShutdownException;
                        boolean bl = isShutdownException = ExceptionUtil.isShutdownException(actualThrowable) || actualThrowable.getMessage().contains("Unloaded chunk");
                        if (!isShutdownException) {
                            CHUNK_LOAD_LOGGER.warn("DistantHorizons: Couldn't load chunk [" + String.valueOf(chunkPos) + "] from server, error: [" + actualThrowable.getMessage() + "].", actualThrowable);
                        }
                    }
                });
                getChunkFutureList.add(requestChunkFuture);
            }
            ArrayList<IChunkWrapper> chunkWrappers = new ArrayList<IChunkWrapper>();
            for (int i = 0; i < getChunkFutureList.size(); ++i) {
                CompletableFuture getChunkFuture = (CompletableFuture)getChunkFutureList.get(i);
                class_2791 chunk2 = (class_2791)getChunkFuture.join();
                if (chunk2 == null) continue;
                ChunkWrapper chunkWrapper = new ChunkWrapper(chunk2, this.dhServerLevel.getLevelWrapper());
                chunkWrappers.add(chunkWrapper);
            }
            int maxSkyLight = this.dhServerLevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            for (int i = 0; i < chunkWrappers.size(); ++i) {
                ChunkWrapper chunkWrapper = (ChunkWrapper)chunkWrappers.get(i);
                if (!chunkWrapper.isDhBlockLightingCorrect()) {
                    DhLightingEngine.INSTANCE.bakeChunkBlockLighting(chunkWrapper, chunkWrappers, maxSkyLight);
                }
                this.dhServerLevel.updateBeaconBeamsForChunk(chunkWrapper, chunkWrappers);
                genEvent.resultConsumer.accept(chunkWrapper);
            }
        }
        finally {
            Iterator<class_1923> chunkPosIterator = ChunkPosGenStream.getIterator(genEvent.minPos.getX(), genEvent.minPos.getZ(), genEvent.widthInChunks, 0);
            while (chunkPosIterator.hasNext()) {
                class_1923 chunkPos = chunkPosIterator.next();
                this.releaseChunkFromServer(this.params.mcServerLevel, chunkPos);
            }
        }
    }

    private void runValidation() {
        if (!DhApi.isDhThread() && ModInfo.IS_DEV_BUILD) {
            throw new IllegalStateException("Internal server generation should be called from one of DH's world gen thread. Current thread: [" + Thread.currentThread().getName() + "]");
        }
        if (C2ME_ACCESSOR == null && !c2meMissingWarningLogged) {
            c2meMissingWarningLogged = true;
            String c2meWarning = "C2ME missing, \nlow CPU usage and slow world gen speeds expected. \nDH is set to use MC's internal server for world gen \nthis mode is less efficient unless a mod like C2ME is present.";
            if (Config.Common.Logging.Warning.showSlowWorldGenSettingWarnings.get().booleanValue()) {
                String message = "\u00a76Distant Horizons: slow world gen.\u00a7r\n" + c2meWarning;
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            LOGGER.warn(c2meWarning, new Object[0]);
        }
    }

    private CompletableFuture<class_2791> requestChunkFromServerAsync(class_1923 chunkPos) {
        return CompletableFuture.supplyAsync(() -> {
            class_3218 level = this.params.mcServerLevel;
            SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.addPosToIgnore(new DhChunkPos(chunkPos.field_9181, chunkPos.field_9180));
            int chunkLevel = 33;
            level.method_14178().field_17252.method_17290(DH_SERVER_GEN_TICKET, chunkPos, chunkLevel, (Object)chunkPos);
            level.method_14178().field_17252.method_15892(level.method_14178().field_17254);
            class_3193 chunkHolder = level.method_14178().field_17254.method_17255(chunkPos.method_8324());
            if (chunkHolder == null) {
                throw new IllegalStateException("No chunk chunkHolder for pos [" + String.valueOf(chunkPos) + "] after ticket has been added.");
            }
            return chunkHolder.method_13993(class_2806.field_12795, level.method_14178().field_17254).thenApply(result -> (class_2791)result.left().orElseThrow(() -> new RuntimeException(((class_3193.class_3724)result.right().get()).toString())));
        }, (Executor)this.params.mcServerLevel.method_14178().field_17254.field_17216).thenCompose(Function.identity());
    }

    private void releaseChunkFromServer(class_3218 level, final class_1923 chunkPos) {
        level.method_14178().field_17254.field_17216.execute(() -> {
            try {
                int chunkLevel = 33;
                level.method_14178().field_17252.method_20444(DH_SERVER_GEN_TICKET, chunkPos, chunkLevel, (Object)chunkPos);
                level.method_14178().field_17254.method_17233(() -> false);
                level.field_26935.method_31809();
                this.chunkSaveIgnoreTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.removePosToIgnore(new DhChunkPos(chunkPos.field_9181, chunkPos.field_9180));
                    }
                }, 5000L);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to release chunk back to internal server. Error: [" + e.getMessage() + "]", e);
            }
        });
    }
}

