/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.block;

import com.google.common.annotations.VisibleForTesting;
import com.ovinter.mythsandlegends.registry.MLBlocks;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PointedBloodstoneBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.f_155997_;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.f_155998_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final int MAX_SEARCH_LENGTH_WHEN_CHECKING_DRIP_TYPE = 11;
    private static final int DELAY_BEFORE_FALLING = 2;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK = 0.02f;
    private static final float DRIP_PROBABILITY_PER_ANIMATE_TICK_IF_UNDER_LIQUID_SOURCE = 0.12f;
    private static final int MAX_SEARCH_LENGTH_BETWEEN_STALACTITE_TIP_AND_CAULDRON = 11;
    private static final float WATER_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.17578125f;
    private static final float LAVA_TRANSFER_PROBABILITY_PER_RANDOM_TICK = 0.05859375f;
    private static final double MIN_TRIDENT_VELOCITY_TO_BREAK_DRIPSTONE = 0.6;
    private static final float STALACTITE_DAMAGE_PER_FALL_DISTANCE_AND_SIZE = 1.0f;
    private static final int STALACTITE_MAX_DAMAGE = 40;
    private static final int MAX_STALACTITE_HEIGHT_FOR_DAMAGE_CALCULATION = 6;
    private static final float STALAGMITE_FALL_DISTANCE_OFFSET = 2.0f;
    private static final int STALAGMITE_FALL_DAMAGE_MODIFIER = 2;
    private static final float AVERAGE_DAYS_PER_GROWTH = 5.0f;
    private static final float GROWTH_PROBABILITY_PER_RANDOM_TICK = 0.011377778f;
    private static final int MAX_GROWTH_LENGTH = 7;
    private static final int MAX_STALAGMITE_SEARCH_RANGE_WHEN_GROWING = 10;
    private static final float STALACTITE_DRIP_START_PIXEL = 0.6875f;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final float MAX_HORIZONTAL_OFFSET = 0.125f;
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public PointedBloodstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TIP_DIRECTION, (Comparable)Direction.UP)).m_61124_(THICKNESS, (Comparable)DripstoneThickness.TIP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_154157_) {
        p_154157_.m_61104_(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return PointedBloodstoneBlock.isValidPointedIciclePlacement(level, pos, (Direction)state.m_61143_((Property)TIP_DIRECTION));
    }

    public BlockState m_7417_(BlockState state, Direction pDirection, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (pDirection != Direction.UP && pDirection != Direction.DOWN) {
            return state;
        }
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && level.m_183326_().m_183582_(pos, (Object)this)) {
            return state;
        }
        if (pDirection == direction.m_122424_() && !this.m_7898_(state, (LevelReader)level, pos)) {
            if (direction == Direction.DOWN) {
                level.m_186460_(pos, (Block)this, 2);
            } else {
                level.m_186460_(pos, (Block)this, 1);
            }
            return state;
        }
        boolean flag = state.m_61143_(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedBloodstoneBlock.calculateDripstoneThickness((LevelReader)level, pos, direction, flag);
        return (BlockState)state.m_61124_(THICKNESS, (Comparable)dripstonethickness);
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos = hit.m_82425_();
        if (!level.f_46443_ && projectile.m_142265_(level, blockpos) && projectile instanceof ThrownTrident && projectile.m_20184_().m_82553_() > 0.6) {
            level.m_46961_(blockpos, true);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.m_61143_((Property)TIP_DIRECTION) == Direction.UP && state.m_61143_(THICKNESS) == DripstoneThickness.TIP) {
            entity.m_142535_(fallDistance + 2.0f, 2.0f, level.m_269111_().m_269571_());
        } else {
            super.m_142072_(level, state, pos, entity, fallDistance);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (PointedBloodstoneBlock.isStalagmite(state) && !this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        } else {
            PointedBloodstoneBlock.spawnFallingStalactite(state, level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188501_() < 0.011377778f && PointedBloodstoneBlock.isStalactiteStartPos(state, (LevelReader)level, pos)) {
            PointedBloodstoneBlock.growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = blockPlaceContext.m_43725_();
        Direction direction1 = PointedBloodstoneBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = blockPlaceContext.m_8083_(), direction = blockPlaceContext.m_151260_().m_122424_());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !blockPlaceContext.m_7078_();
        DripstoneThickness dripstonethickness = PointedBloodstoneBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction1)).m_61124_(THICKNESS, (Comparable)dripstonethickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.m_6425_(blockpos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (state.m_61143_((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.m_60824_(blockGetter, pos);
        return voxelshape.m_83216_(vec3.f_82479_, 0.0, vec3.f_82481_);
    }

    public boolean m_180643_(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return false;
    }

    public float m_142740_() {
        return 0.125f;
    }

    public void m_142525_(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.m_20067_()) {
            level.m_46796_(1045, pos, 0);
        }
    }

    public DamageSource m_252932_(Entity entity) {
        return entity.m_269291_().m_269103_(entity);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        BlockState blockstate = state;
        while (PointedBloodstoneBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (PointedBloodstoneBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.m_123342_() - blockpos$mutableblockpos.m_123342_(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.m_149656_(f, 40);
                break;
            }
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        BlockState blockState1;
        BlockPos blockpos;
        BlockState blockState = level.m_8055_(pos.m_6630_(1));
        if (PointedBloodstoneBlock.canGrow(blockState) && (blockpos = PointedBloodstoneBlock.findTip(state, (LevelAccessor)level, pos, 7, false)) != null && PointedBloodstoneBlock.canDrip(blockState1 = level.m_8055_(blockpos)) && PointedBloodstoneBlock.canTipGrow(blockState1, level, blockpos)) {
            if (randomSource.m_188499_()) {
                PointedBloodstoneBlock.grow(level, blockpos, Direction.DOWN);
            } else {
                PointedBloodstoneBlock.growStalagmiteBelow(level, blockpos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
            BlockState blockstate = level.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.m_60819_().m_76178_()) {
                return;
            }
            if (PointedBloodstoneBlock.isUnmergedTipWithDirection(blockstate, Direction.UP) && PointedBloodstoneBlock.canTipGrow(blockstate, level, (BlockPos)blockpos$mutableblockpos)) {
                PointedBloodstoneBlock.grow(level, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (PointedBloodstoneBlock.isValidPointedIciclePlacement((LevelReader)level, (BlockPos)blockpos$mutableblockpos, Direction.UP) && !level.m_46801_(blockpos$mutableblockpos.m_7495_())) {
                PointedBloodstoneBlock.grow(level, blockpos$mutableblockpos.m_7495_(), Direction.UP);
                return;
            }
            if (PointedBloodstoneBlock.canDripThrough((BlockGetter)level, (BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return;
        }
    }

    private static void grow(ServerLevel level, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_121945_(direction);
        BlockState blockstate = level.m_8055_(blockpos);
        if (PointedBloodstoneBlock.isUnmergedTipWithDirection(blockstate, direction.m_122424_())) {
            PointedBloodstoneBlock.createMergedTips(blockstate, (LevelAccessor)level, blockpos);
        } else if (blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49990_)) {
            PointedBloodstoneBlock.createDripstone((LevelAccessor)level, blockpos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor levelAccessor, BlockPos pos, Direction direction, DripstoneThickness dripstoneThickness) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)MLBlocks.POINTED_BLOODSTONE.get()).m_49966_().m_61124_((Property)TIP_DIRECTION, (Comparable)direction)).m_61124_(THICKNESS, (Comparable)dripstoneThickness)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        levelAccessor.m_7731_(pos, blockstate, 3);
    }

    private static void createMergedTips(BlockState state, LevelAccessor levelAccessor, BlockPos pos) {
        BlockPos blockPos;
        BlockPos blockPos1;
        if (state.m_61143_((Property)TIP_DIRECTION) == Direction.UP) {
            blockPos1 = pos;
            blockPos = pos.m_7494_();
        } else {
            blockPos = pos;
            blockPos1 = pos.m_7495_();
        }
        PointedBloodstoneBlock.createDripstone(levelAccessor, blockPos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        PointedBloodstoneBlock.createDripstone(levelAccessor, blockPos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor levelAccessor, BlockPos pos, int maxIterations, boolean isTipMerge) {
        if (PointedBloodstoneBlock.isTip(state, isTipMerge)) {
            return pos;
        }
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (blockPos, blockState) -> blockState.m_60713_((Block)MLBlocks.POINTED_BLOODSTONE.get()) && blockState.m_61143_((Property)TIP_DIRECTION) == direction;
        return PointedBloodstoneBlock.findBlockVertical(levelAccessor, pos, direction.m_122421_(), bipredicate, blockState -> PointedBloodstoneBlock.isTip(blockState, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader levelReader, BlockPos pos, Direction pDirection) {
        Direction direction;
        if (PointedBloodstoneBlock.isValidPointedIciclePlacement(levelReader, pos, pDirection)) {
            direction = pDirection;
        } else {
            if (!PointedBloodstoneBlock.isValidPointedIciclePlacement(levelReader, pos, pDirection.m_122424_())) {
                return null;
            }
            direction = pDirection.m_122424_();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader levelReader, BlockPos pos, Direction pDirection, boolean isTipMerge) {
        Direction direction = pDirection.m_122424_();
        BlockState blockState = levelReader.m_8055_(pos.m_121945_(pDirection));
        if (PointedBloodstoneBlock.isPointedDripstoneWithDirection(blockState, direction)) {
            return !isTipMerge && blockState.m_61143_(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedBloodstoneBlock.isPointedDripstoneWithDirection(blockState, pDirection)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstoneThickness = (DripstoneThickness)blockState.m_61143_(THICKNESS);
        if (dripstoneThickness != DripstoneThickness.TIP && dripstoneThickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockState1 = levelReader.m_8055_(pos.m_121945_(direction));
            return !PointedBloodstoneBlock.isPointedDripstoneWithDirection(blockState1, pDirection) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return PointedBloodstoneBlock.isStalactite(state) && state.m_61143_(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)TIP_DIRECTION);
        BlockPos blockPos = pos.m_121945_(direction);
        BlockState blockState = level.m_8055_(blockPos);
        if (!blockState.m_60819_().m_76178_()) {
            return false;
        }
        return blockState.m_60795_() ? true : PointedBloodstoneBlock.isUnmergedTipWithDirection(blockState, direction.m_122424_());
    }

    private static boolean isValidPointedIciclePlacement(LevelReader levelReader, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        BlockState blockState = levelReader.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)levelReader, blockPos, direction) || PointedBloodstoneBlock.isPointedDripstoneWithDirection(blockState, direction);
    }

    private static boolean isTip(BlockState state, boolean isTipMerge) {
        if (!state.m_60713_((Block)MLBlocks.POINTED_BLOODSTONE.get())) {
            return false;
        }
        DripstoneThickness dripstoneThickness = (DripstoneThickness)state.m_61143_(THICKNESS);
        return dripstoneThickness == DripstoneThickness.TIP || isTipMerge && dripstoneThickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction direction) {
        return PointedBloodstoneBlock.isTip(state, false) && state.m_61143_((Property)TIP_DIRECTION) == direction;
    }

    private static boolean isStalactite(BlockState p_154241_) {
        return PointedBloodstoneBlock.isPointedDripstoneWithDirection(p_154241_, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState p_154243_) {
        return PointedBloodstoneBlock.isPointedDripstoneWithDirection(p_154243_, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader levelReader, BlockPos pos) {
        return PointedBloodstoneBlock.isStalactite(state) && !levelReader.m_8055_(pos.m_7494_()).m_60713_((Block)MLBlocks.POINTED_BLOODSTONE.get());
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction direction) {
        return state.m_60713_((Block)MLBlocks.POINTED_BLOODSTONE.get()) && state.m_61143_((Property)TIP_DIRECTION) == direction;
    }

    private static boolean canGrow(BlockState state) {
        return state.m_204336_(BlockTags.f_13047_);
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor levelAccessor, BlockPos pos, Direction.AxisDirection axisDirection, BiPredicate<BlockPos, BlockState> stateBiPredicate, Predicate<BlockState> statePredicate, int maxIterations) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        for (int i = 1; i < maxIterations; ++i) {
            blockpos$mutableblockpos.m_122173_(direction);
            BlockState blockState = levelAccessor.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (statePredicate.test(blockState)) {
                return Optional.of(blockpos$mutableblockpos.m_7949_());
            }
            if (!levelAccessor.m_151562_(blockpos$mutableblockpos.m_123342_()) && stateBiPredicate.test((BlockPos)blockpos$mutableblockpos, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter blockGetter, BlockPos pos, BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60804_(blockGetter, pos)) {
            return false;
        }
        if (!state.m_60819_().m_76178_()) {
            return false;
        }
        VoxelShape voxelshape = state.m_60812_(blockGetter, pos);
        return !Shapes.m_83157_((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_);
    }
}

