/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.block.entity;

import com.ovinter.mythsandlegends.entity.CondemnedEntity;
import com.ovinter.mythsandlegends.registry.MLEntities;
import com.ovinter.mythsandlegends.registry.MLSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TombstoneBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape BASE = Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)2.0, (double)11.0);
    private static final VoxelShape BASE2 = Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)2.0, (double)15.0);
    private static final VoxelShape MIDDLE_NORTH = Block.m_49796_((double)1.0, (double)2.0, (double)7.0, (double)15.0, (double)15.0, (double)11.0);
    private static final VoxelShape MIDDLE_SOUTH = Block.m_49796_((double)1.0, (double)2.0, (double)5.0, (double)15.0, (double)15.0, (double)9.0);
    private static final VoxelShape MIDDLE_EAST = Block.m_49796_((double)5.0, (double)2.0, (double)1.0, (double)9.0, (double)15.0, (double)15.0);
    private static final VoxelShape MIDDLE_WEST = Block.m_49796_((double)7.0, (double)2.0, (double)1.0, (double)11.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)MIDDLE_NORTH);
    private static final VoxelShape SHAPE_SOUTH = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)MIDDLE_SOUTH);
    private static final VoxelShape SHAPE_EAST = Shapes.m_83110_((VoxelShape)BASE2, (VoxelShape)MIDDLE_EAST);
    private static final VoxelShape SHAPE_WEST = Shapes.m_83110_((VoxelShape)BASE2, (VoxelShape)MIDDLE_WEST);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty IS_HAUNTED = BlockStateProperties.f_222997_;

    public TombstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_HAUNTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
        builder.m_61104_(new Property[]{WATERLOGGED});
        builder.m_61104_(new Property[]{IS_HAUNTED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean isWater = fluidState.m_76152_() == Fluids.f_76193_;
        boolean haunted = pContext.m_43725_().m_213780_().m_188501_() < 0.5f;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater))).m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)IS_HAUNTED, (Comparable)Boolean.valueOf(haunted));
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)f_54117_)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!level.f_46443_) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_HAUNTED, (Comparable)Boolean.valueOf(false)), 3);
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (((Boolean)pState.m_61143_((Property)IS_HAUNTED)).booleanValue()) {
            this.tryToSpawnCondemnedSoul(pLevel, pPos);
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)IS_HAUNTED)).booleanValue()) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
        }
    }

    private void tryToSpawnCondemnedSoul(Level level, BlockPos pos) {
        CondemnedEntity condemned = new CondemnedEntity((EntityType<? extends Monster>)((EntityType)MLEntities.CONDEMNED.get()), level);
        condemned.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        level.m_7967_((Entity)condemned);
        level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)MLSounds.JUMP_SCARE.get(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
    }
}

