/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.datagen;

import com.ovinter.mythsandlegends.registry.MLItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;

public class MLAdvancementProvider
extends ForgeAdvancementProvider {
    public MLAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper existingFileHelper) {
        super(output, provider, existingFileHelper, List.of(new MLAdvancementGenerator()));
    }

    private static class MLAdvancementGenerator
    implements ForgeAdvancementProvider.AdvancementGenerator {
        private MLAdvancementGenerator() {
        }

        public void generate(HolderLookup.Provider registries, Consumer<Advancement> consumer, ExistingFileHelper fileHelper) {
            Advancement root = Advancement.Builder.m_138353_().m_138371_((ItemLike)MLItems.CURSED_CORE.get(), (Component)Component.m_237115_((String)"advancements.mythsandlegends.root.title"), (Component)Component.m_237115_((String)"advancements.mythsandlegends.root.description"), ResourceLocation.withDefaultNamespace((String)"textures/block/blackstone.png"), FrameType.TASK, false, false, false).m_138386_("mythsandlegends", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_272050_()).m_138389_(consumer, MLAdvancementGenerator.id("root"));
            Advancement cursedPower = this.createItemAdvancement("cursed_power", (Item)MLItems.CURSED_CORE.get(), root, consumer, FrameType.TASK);
            Advancement boundSoulIngot = this.createItemAdvancement("bound_soul_ingot", (Item)MLItems.BOUND_SOUL_INGOT.get(), cursedPower, consumer, FrameType.TASK);
            Advancement fragmentOfPower = this.createItemAdvancement("fragment_of_power", (Item)MLItems.GARGOYLE_FRAGMENT.get(), root, consumer, FrameType.TASK);
            Advancement shardCollector = this.createItemAdvancement("shard_collector", (Item)MLItems.GARGOYLE_SHARD.get(), root, consumer, FrameType.TASK);
            Advancement warbornConqueror = this.createEntityKillAdvancement("warborn_conqueror", (Item)MLItems.INFERNUM_WARPLATE_HELMET.get(), MLAdvancementGenerator.id("warborn_aegis"), root, consumer);
            Advancement echoInTheFrost = this.createEntityKillAdvancement("echo_in_the_frost", (Item)MLItems.KARAKONDJUL_HORN.get(), MLAdvancementGenerator.id("karakondjul"), root, consumer);
            this.createItemAdvancement("bound_by_darkness", (Item)MLItems.IRONSHADE_HELMET.get(), boundSoulIngot, consumer, FrameType.CHALLENGE);
            this.createItemAdvancement("heart_of_fire", (Item)MLItems.FIRE_HEART.get(), root, consumer, FrameType.TASK);
            this.createEntityKillAdvancement("rider_of_the_shadows", (Item)MLItems.SOULBINDER_AMULET.get(), MLAdvancementGenerator.id("black_charro"), root, consumer);
            this.createEquipmentAdvancement("the_stonewall", (Item)MLItems.STONY_SHIELD.get(), fragmentOfPower, consumer);
            this.createEquipmentAdvancement("master_of_the_blade", (Item)MLItems.GARGOYLE_AXE.get(), shardCollector, consumer);
            this.createEquipmentAdvancement("forged_in_inferno", (Item)MLItems.INFERNUM_WARPLATE_CHESTPLATE.get(), warbornConqueror, consumer);
            this.createEquipmentAdvancement("aegis_of_the_damned", (Item)MLItems.MALEDICTUM_SHIELD.get(), warbornConqueror, consumer);
            this.createItemAdvancement("frozen_heart", (Item)MLItems.FROZEN_HEART.get(), echoInTheFrost, consumer, FrameType.TASK);
            this.createItemAdvancement("relic_of_the_forge_god", (Item)MLItems.SVAROGS_RING.get(), root, consumer, FrameType.TASK);
            this.createItemAdvancement("ars_lapidem", (Item)MLItems.GARGOYLE_EFFIGY.get(), cursedPower, consumer, FrameType.CHALLENGE);
            Advancement howlOfTheLonelyEnd = this.createEntityKillAdvancement("howl_of_the_lonely_end", (Item)MLItems.AMAROK_ESSENCE.get(), MLAdvancementGenerator.id("amarok"), root, consumer);
            this.createItemAdvancement("reliquary_of_the_northern_spirit", (Item)MLItems.NECKLACE_OF_TORNGARSUK.get(), howlOfTheLonelyEnd, consumer, FrameType.CHALLENGE);
        }

        private static String id(String name) {
            return ResourceLocation.fromNamespaceAndPath((String)"mythsandlegends", (String)name).toString();
        }

        private Advancement createItemAdvancement(String name, Item item, Advancement parent, Consumer<Advancement> consumer, FrameType type) {
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_((ItemLike)item, (Component)Component.m_237115_((String)("advancements.mythsandlegends." + name + ".title")), (Component)Component.m_237115_((String)("advancements.mythsandlegends." + name + ".description")), null, type, true, true, false).m_138386_("obtain_" + name, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{item})).m_138389_(consumer, MLAdvancementGenerator.id(name));
        }

        private Advancement createEntityKillAdvancement(String name, Item displayItem, String entityId, Advancement parent, Consumer<Advancement> consumer) {
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_((ItemLike)displayItem, (Component)Component.m_237115_((String)("advancements.mythsandlegends." + name + ".title")), (Component)Component.m_237115_((String)("advancements.mythsandlegends." + name + ".description")), null, FrameType.CHALLENGE, true, true, false).m_138386_("kill_" + name, (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)EntityType.m_20632_((String)entityId).orElseThrow()))).m_138389_(consumer, MLAdvancementGenerator.id(name));
        }

        private Advancement createEquipmentAdvancement(String name, Item resultItem, Advancement parentName, Consumer<Advancement> consumer) {
            return Advancement.Builder.m_138353_().m_138398_(parentName).m_138371_((ItemLike)resultItem, (Component)Component.m_237115_((String)("advancements.mythsandlegends." + name + ".title")), (Component)Component.m_237115_((String)("advancements.mythsandlegends." + name + ".description")), null, FrameType.GOAL, true, true, false).m_138386_("craft_" + name, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{resultItem})).m_138389_(consumer, MLAdvancementGenerator.id(name));
        }
    }
}

