/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity;

import com.ovinter.mythsandlegends.Config;
import com.ovinter.mythsandlegends.api.util.ParticleGeneratorHelper;
import com.ovinter.mythsandlegends.config.DefaultMobAttributes;
import com.ovinter.mythsandlegends.entity.MLEntity;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.AnimatedMeleeAttackGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.generic.ChaseTargetGoal;
import com.ovinter.mythsandlegends.entity.ai.goal.karakondjul.SleepGoal;
import com.ovinter.mythsandlegends.registry.MLSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KarakondjulEntity
extends MLEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("IDLE");
    private final RawAnimation WALK = RawAnimation.begin().thenLoop("WALK");
    private final RawAnimation RUN = RawAnimation.begin().thenLoop("RUN");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("ATTACK");
    private final RawAnimation SLEEP_ANIM = RawAnimation.begin().thenLoop("SLEEP");
    private final RawAnimation DEATH = RawAnimation.begin().thenPlay("DEATH");
    public final int SLEEP = 3;
    private static final EntityDataAccessor<Boolean> DATA_IS_SLEEPING = SynchedEntityData.m_135353_(KarakondjulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public KarakondjulEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, DefaultMobAttributes.KARAKONDJUL_HEALTH).m_22268_(Attributes.f_22284_, DefaultMobAttributes.KARAKONDJUL_ARMOR).m_22268_(Attributes.f_22285_, DefaultMobAttributes.KARAKONDJUL_ARMOR_TOUGHNESS).m_22268_(Attributes.f_22281_, DefaultMobAttributes.KARAKONDJUL_DAMAGE).m_22268_(Attributes.f_22279_, DefaultMobAttributes.KARAKONDJUL_MOVEMENT).m_22268_(Attributes.f_22277_, DefaultMobAttributes.KARAKONDJUL_FOLLOW_RANGE).m_22268_(Attributes.f_22278_, DefaultMobAttributes.KARAKONDJUL_KNOCKBACK_RESISTANCE);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new SleepGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new AnimatedMeleeAttackGoal(this, 20, 3, 3.0f));
        this.f_21345_.m_25352_(4, (Goal)new ChaseTargetGoal(this, false, 1.6));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{KarakondjulEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_SLEEPING, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setIsSleeping(pCompound.m_128471_("IsSleeping"));
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsSleeping", this.getIsSleeping());
    }

    protected void m_8024_() {
        if (this.getAttackTicks() > 0) {
            this.setAttackTicks(this.getAttackTicks() - 1);
        }
        super.m_8024_();
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 25 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_7822_(byte id) {
        if (id == 69) {
            ParticleGeneratorHelper.generateHealingParticles(this.m_9236_(), (LivingEntity)this);
        }
        super.m_7822_(id);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setConfigAttributes();
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_7327_(Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            this.applyFreezingEffect(livingEntity);
        }
        return super.m_7327_(pEntity);
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_7307_(Entity pEntity) {
        if (pEntity == this) {
            return true;
        }
        if (pEntity.getClass() == this.getClass()) {
            return true;
        }
        return super.m_7307_(pEntity);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)MLSounds.KARAKONDJUL_AMBIENT.get();
    }

    @NotNull
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)MLSounds.KARAKONDJUL_HURT.get();
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return (SoundEvent)MLSounds.KARAKONDJUL_DEATH.get();
    }

    public void setIsSleeping(boolean pIsSleeping) {
        this.f_19804_.m_135381_(DATA_IS_SLEEPING, (Object)pIsSleeping);
    }

    public boolean getIsSleeping() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SLEEPING);
    }

    @Override
    PlayState movementPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return state.setAndContinue(this.DEATH);
        }
        if (this.getIsSleeping()) {
            return state.setAndContinue(this.SLEEP_ANIM);
        }
        if (state.isMoving() && this.isRunning()) {
            return state.setAndContinue(this.RUN);
        }
        return state.isMoving() ? state.setAndContinue(this.WALK) : state.setAndContinue(this.IDLE);
    }

    @Override
    PlayState attackPredicate(AnimationState<?> state) {
        if (this.m_21224_()) {
            return PlayState.STOP;
        }
        if (this.getAnimationId() == 1 && this.getAttackTicks() == 19) {
            state.getController().forceAnimationReset();
            return state.setAndContinue(this.ATTACK);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movementController", 5, this::movementPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 5, this::attackPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    void setConfigAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.KARAKONDJUL_HEALTH.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)Config.KARAKONDJUL_ARMOR.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)Config.KARAKONDJUL_ARMOR_TOUGHNESS.get()).doubleValue());
        this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Config.KARAKONDJUL_DAMAGE.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)Config.KARAKONDJUL_KNOCKBACK_RESISTANCE.get()).doubleValue());
        this.m_21153_((float)((Double)Config.KARAKONDJUL_HEALTH.get()).doubleValue());
    }

    void applyFreezingEffect(LivingEntity pTarget) {
        int current = pTarget.m_146888_();
        int max = pTarget.m_146891_();
        int freezeAmount = 60;
        pTarget.m_146917_(Math.min(current + freezeAmount, max));
    }
}

