/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.alp;

import com.ovinter.mythsandlegends.api.util.SendMessageToPlayerHelper;
import com.ovinter.mythsandlegends.datagen.tags.MLItemTag;
import com.ovinter.mythsandlegends.entity.AlpEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;

public class StealItemAndFleeFromPlayerGoal
extends Goal {
    private final AlpEntity mob;
    private Player target;
    private int stealCooldown;
    private int fleeTicks;
    private ItemStack stolenItem;
    private BlockPos fleeTargetPos = null;
    private static final double STEAL_DISTANCE = 2.5;
    private static final double MIN_TARGET_DISTANCE = 10.0;
    private static final int STEAL_COOLDOWN = 60;
    private static final int FLEE_DURATION = 200;

    public StealItemAndFleeFromPlayerGoal(AlpEntity pMob) {
        this.mob = pMob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.stealCooldown > 0) {
            --this.stealCooldown;
            return false;
        }
        this.target = this.getNearestPlayer();
        return this.target != null && this.stealCooldown == 0 && this.mob.m_6084_();
    }

    public boolean m_8045_() {
        return this.fleeTicks > 0 || this.target != null && this.target.m_6084_() && this.mob.m_20280_((Entity)this.target) < 100.0;
    }

    public void m_8056_() {
        this.fleeTicks = 0;
        this.stealCooldown = 0;
        this.stolenItem = ItemStack.f_41583_;
        this.mob.setRunning(true);
        this.mob.m_21573_().m_5624_((Entity)this.target, 1.2);
    }

    public void m_8037_() {
        if (this.target == null || !this.target.m_6084_()) {
            this.m_8041_();
            return;
        }
        if (this.fleeTicks > 0) {
            --this.fleeTicks;
            this.fleeFromTarget();
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        double distanceSqr = this.mob.m_20280_((Entity)this.target);
        if (distanceSqr > 100.0) {
            this.mob.m_21573_().m_5624_((Entity)this.target, 1.5);
        } else if (distanceSqr <= 6.25) {
            this.tryToStealItemFromPlayer();
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.target, 1.5);
        }
    }

    public void m_8041_() {
        this.mob.setRunning(false);
        this.target = null;
        this.fleeTicks = 0;
        this.stealCooldown = 60;
    }

    private void tryToStealItemFromPlayer() {
        if (!this.mob.m_21205_().m_41619_()) {
            this.m_8041_();
            return;
        }
        Inventory inventory = this.target.m_150109_();
        ArrayList<Integer> nonEmptyslots = new ArrayList<Integer>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            nonEmptyslots.add(i);
        }
        if (nonEmptyslots.isEmpty()) {
            return;
        }
        int slot = (Integer)nonEmptyslots.get(this.mob.m_217043_().m_188503_(nonEmptyslots.size()));
        ItemStack stackInSlot = inventory.m_8020_(slot);
        if (!stackInSlot.m_41619_() && !stackInSlot.m_204117_(MLItemTag.ItemTypes.IGNORED_BY_ALP)) {
            this.stolenItem = stackInSlot.m_41777_();
            this.stolenItem.m_41764_(1);
            inventory.m_7407_(slot, 1);
            this.mob.m_21008_(InteractionHand.MAIN_HAND, this.stolenItem);
            this.mob.setHasStolen(true);
            SendMessageToPlayerHelper.displayClientMessage((Component)Component.m_237110_((String)"text.mythsandlegends.alp_steal_item", (Object[])new Object[]{this.stolenItem.m_41786_()}), this.target, true);
            this.fleeTicks = 200;
            this.mob.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
            this.mob.m_7327_((Entity)this.target);
        }
    }

    private void fleeFromTarget() {
        BlockPos safePos;
        double dz;
        if (this.target == null) {
            return;
        }
        if (this.fleeTargetPos != null && this.mob.m_21573_().m_26572_()) {
            return;
        }
        double dx = this.mob.m_20185_() - this.target.m_20185_();
        double dist = Math.sqrt(dx * dx + (dz = this.mob.m_20189_() - this.target.m_20189_()) * dz);
        if (dist == 0.0) {
            return;
        }
        double escapeX = this.mob.m_20185_() + (dx /= dist) * 10.0;
        double escapeZ = this.mob.m_20189_() + (dz /= dist) * 10.0;
        BlockPos rawPos = BlockPos.m_274561_((double)escapeX, (double)this.mob.m_20186_(), (double)escapeZ);
        this.fleeTargetPos = safePos = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, rawPos);
        this.mob.m_21573_().m_26519_((double)safePos.m_123341_(), (double)safePos.m_123342_(), (double)safePos.m_123343_(), 1.5);
        if (this.mob.m_20280_((Entity)this.target) > 100.0) {
            this.dropStolenItem();
        }
    }

    private Player getNearestPlayer() {
        List players = this.mob.m_9236_().m_6443_(Player.class, this.mob.m_20191_().m_82400_(12.0), player -> player.m_6084_() && !player.m_150109_().m_7983_() && !player.m_7500_() && !player.m_5833_());
        if (players.isEmpty()) {
            return null;
        }
        return (Player)players.get(0);
    }

    private void dropStolenItem() {
        if (!this.stolenItem.m_41619_()) {
            this.mob.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            this.mob.m_19983_(this.stolenItem.m_41777_());
            this.stolenItem = ItemStack.f_41583_;
        }
        this.mob.setHasStolen(false);
        this.mob.setRunning(false);
        this.fleeTicks = 0;
        this.fleeTargetPos = null;
    }
}

