/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.goal.inquisitor;

import com.ovinter.mythsandlegends.entity.PossessedArmorInquisitorEntity;
import com.ovinter.mythsandlegends.registry.MLSounds;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class SlamAttackGoal
extends Goal {
    private final PossessedArmorInquisitorEntity mob;
    private LivingEntity target;
    private int attackTick;
    private final int ATTACK_DURATION = 45;

    public SlamAttackGoal(PossessedArmorInquisitorEntity pMob) {
        this.mob = pMob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        return this.target != null && this.target.m_6084_() && this.mob.m_20096_() && this.mob.slamCooldown == 0 && this.mob.getAnimationId() == 0 && this.mob.m_20270_((Entity)this.target) <= 5.0f && !this.mob.m_21224_() && !this.mob.isStunned();
    }

    public boolean m_8045_() {
        return this.target != null && this.mob.slamCooldown <= 0 && this.target.m_6084_();
    }

    public void m_8056_() {
        this.mob.setAnimationId(this.mob.SUMMON);
        this.attackTick = 0;
    }

    public void m_8037_() {
        ++this.attackTick;
        if (this.mob.isStunned()) {
            this.m_8041_();
        }
        if (this.target != null) {
            if (this.attackTick == 20) {
                this.performSlamAttack();
            }
            if (this.attackTick >= 45) {
                this.m_8041_();
            }
        }
    }

    public void m_8041_() {
        this.target = null;
        this.mob.setAnimationId(0);
        this.attackTick = 0;
        this.mob.slamCooldown = this.mob.SLAM_COOLDOWN;
    }

    public boolean m_183429_() {
        return true;
    }

    void performSlamAttack() {
        Level level = this.mob.m_9236_();
        List entities = level.m_6443_(Entity.class, this.mob.m_20191_().m_82400_(6.0), entity -> !(entity instanceof PossessedArmorInquisitorEntity));
        for (Entity entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            double deltaX = entity2.m_20185_() - this.mob.m_20185_();
            double deltaZ = entity2.m_20189_() - this.mob.m_20189_();
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            entity2.m_6469_(level.m_269111_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21051_(Attributes.f_22281_).m_22135_());
            if (distance == 0.0) continue;
            ((LivingEntity)entity2).m_147240_(3.0, -deltaX / distance, -deltaZ / distance);
        }
        level.m_7605_((Entity)this.mob, (byte)69);
        level.m_247517_(null, this.mob.m_20183_(), (SoundEvent)MLSounds.SHOCKWAVE.get(), SoundSource.HOSTILE);
    }
}

