/*
 * Decompiled with CFR 0.152.
 */
package com.ovinter.mythsandlegends.entity.ai.navigation;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FlyingNavigation
extends FlyingPathNavigation {
    private int obstacleCheckCooldown = 0;
    private Vec3 lastEscapeDirection = Vec3.f_82478_;

    public FlyingNavigation(Mob entity, Level level) {
        super(entity, level);
    }

    protected void m_7636_() {
        if (this.obstacleCheckCooldown <= 0) {
            Vec3 currentPos = this.f_26494_.m_20182_();
            BlockPos obstacle = this.findObstacle(currentPos, 3);
            if (obstacle != null) {
                this.lastEscapeDirection = this.calculateEscapeVector(currentPos, obstacle);
                this.replanPathAwayFromObstacle(currentPos, this.lastEscapeDirection);
                this.obstacleCheckCooldown = 10;
            }
        } else {
            --this.obstacleCheckCooldown;
        }
        if (!this.lastEscapeDirection.equals((Object)Vec3.f_82478_)) {
            this.smoothMovementTransition();
        }
        super.m_7636_();
    }

    private void replanPathAwayFromObstacle(Vec3 currentPos, Vec3 escapeDirection) {
        Vec3 escapeTarget = currentPos.m_82549_(escapeDirection.m_82490_(4.0));
        BlockPos targetPos = BlockPos.m_274446_((Position)escapeTarget);
        Path path = this.m_7864_(targetPos, 1);
        if (path != null) {
            this.f_26496_ = path;
        }
    }

    private void smoothMovementTransition() {
        Vec3 desiredMotion = this.lastEscapeDirection.m_82490_(this.f_26494_.m_21133_(Attributes.f_22280_) * 0.7);
        Vec3 currentMotion = this.f_26494_.m_20184_();
        Vec3 newMotion = currentMotion.m_165921_(desiredMotion, 0.3);
        this.f_26494_.m_20256_(newMotion);
        this.lastEscapeDirection = this.lastEscapeDirection.m_82490_(0.8);
        if (this.lastEscapeDirection.m_82556_() < 0.01) {
            this.lastEscapeDirection = Vec3.f_82478_;
        }
    }

    public boolean m_26519_(double x, double y, double z, double speed) {
        this.lastEscapeDirection = Vec3.f_82478_;
        return super.m_26519_(x, y, z, speed);
    }

    private BlockPos findObstacle(Vec3 position, int range) {
        BlockPos center = BlockPos.m_274446_((Position)position);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    mutablePos.m_122178_(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                    if (!this.f_26494_.m_9236_().m_8055_((BlockPos)mutablePos).m_280296_() || !this.f_26494_.m_20191_().m_82381_(new AABB((BlockPos)mutablePos))) continue;
                    return mutablePos.m_7949_();
                }
            }
        }
        Vec3 velocity = this.f_26494_.m_20184_();
        if (velocity.m_82556_() > 0.001) {
            Vec3 futurePos = position.m_82549_(velocity.m_82490_(1.5));
            BlockPos futureCenter = BlockPos.m_274446_((Position)futurePos);
            for (int y = -range; y <= range; ++y) {
                for (int x = -range; x <= range; ++x) {
                    for (int z = -range; z <= range; ++z) {
                        mutablePos.m_122178_(futureCenter.m_123341_() + x, futureCenter.m_123342_() + y, futureCenter.m_123343_() + z);
                        BlockState state = this.f_26494_.m_9236_().m_8055_((BlockPos)mutablePos);
                        if (!state.m_280296_() || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13041_)) continue;
                        AABB blockBB = new AABB((BlockPos)mutablePos);
                        AABB expandedBB = this.f_26494_.m_20191_().m_82400_(0.3);
                        if (!expandedBB.m_82381_(blockBB)) continue;
                        return mutablePos.m_7949_();
                    }
                }
            }
        }
        return null;
    }

    private Vec3 calculateEscapeVector(Vec3 entityPos, BlockPos obstacle) {
        Vec3 obstacleCenter = Vec3.m_82512_((Vec3i)obstacle);
        Vec3 toObstacle = obstacleCenter.m_82546_(entityPos).m_82541_();
        Random random = (Random)this.f_26494_.m_217043_();
        ArrayList<Vec3> escapeDirections = new ArrayList<Vec3>();
        escapeDirections.add(toObstacle.m_82548_());
        Vec3 horizontalPerp = new Vec3(-toObstacle.f_82481_, 0.0, toObstacle.f_82479_).m_82541_();
        escapeDirections.add(horizontalPerp);
        escapeDirections.add(horizontalPerp.m_82548_());
        escapeDirections.add(new Vec3(0.0, 1.0, 0.0));
        escapeDirections.add(new Vec3(0.0, -1.0, 0.0));
        escapeDirections.add(horizontalPerp.m_82520_(0.0, 0.5, 0.0).m_82541_());
        escapeDirections.add(horizontalPerp.m_82548_().m_82520_(0.0, 0.5, 0.0).m_82541_());
        Vec3 bestDirection = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        for (Vec3 dir : escapeDirections) {
            double score = this.evaluateEscapeDirection(entityPos, dir, obstacle);
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestDirection = dir;
        }
        if (bestDirection == null) {
            return new Vec3(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5).m_82541_();
        }
        return bestDirection.m_82520_((random.nextDouble() - 0.5) * 0.2, (random.nextDouble() - 0.5) * 0.2, (random.nextDouble() - 0.5) * 0.2).m_82541_();
    }

    private double evaluateEscapeDirection(Vec3 entityPos, Vec3 direction, BlockPos obstacle) {
        double score = 0.0;
        Vec3 testPos = entityPos.m_82549_(direction.m_82490_(3.0));
        if (!this.f_26494_.m_9236_().m_8055_(BlockPos.m_274446_((Position)testPos)).m_280296_()) {
            score += 50.0;
        }
        Vec3 toObstacle = Vec3.m_82512_((Vec3i)obstacle).m_82546_(testPos);
        score += toObstacle.m_82553_() * 5.0;
        score -= Math.abs(testPos.f_82480_ - entityPos.f_82480_) * 2.0;
        Vec3 currentMotion = this.f_26494_.m_20184_().m_82541_();
        if (currentMotion.m_82556_() > 0.01) {
            score += direction.m_82526_(currentMotion) * 10.0;
        }
        for (int i = 1; i <= 2; ++i) {
            Vec3 checkPos = entityPos.m_82549_(direction.m_82490_((double)i));
            if (!this.f_26494_.m_9236_().m_8055_(BlockPos.m_274446_((Position)checkPos)).m_280296_()) continue;
            score -= 30.0 / (double)i;
        }
        return score;
    }
}

