/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.mixin;

import fuzs.barteringstation.capability.BarteringStationCapability;
import fuzs.barteringstation.init.ModRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PiglinAi.class})
abstract class PiglinAiMixin {
    PiglinAiMixin() {
    }

    @Inject(method={"stopHoldingOffHandItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/monster/piglin/PiglinAi;getBarterResponseItems(Lnet/minecraft/world/entity/monster/piglin/Piglin;)Ljava/util/List;")}, cancellable=true)
    private static void stopHoldingOffHandItem(Piglin piglin, boolean finishedHolding, CallbackInfo callback) {
        if (piglin.m_9236_().f_46443_) {
            return;
        }
        Optional optional = ModRegistry.BARTERING_STATION_CAPABILITY.maybeGet((Object)piglin);
        if (optional.isPresent() && optional.map(BarteringStationCapability::hasBarteringStationPos).orElseThrow().booleanValue()) {
            BarteringStationCapability capability = (BarteringStationCapability)optional.orElseThrow(IllegalStateException::new);
            BlockPos pos = capability.getBarteringStationPos();
            capability.clearBarteringStationPos();
            piglin.m_9236_().m_141902_(pos, (BlockEntityType)ModRegistry.BARTERING_STATION_BLOCK_ENTITY_TYPE.get()).ifPresent(blockEntity -> {
                List<ItemStack> items = PiglinAiMixin.m_34996_(piglin);
                items.removeIf(blockEntity::placeBarterResponseItem);
                if (!items.isEmpty()) {
                    PiglinAiMixin.m_34860_(piglin, items);
                } else {
                    piglin.m_6674_(InteractionHand.OFF_HAND);
                }
                callback.cancel();
            });
        }
    }

    @Shadow
    private static List<ItemStack> m_34996_(Piglin p_34997_) {
        throw new IllegalStateException();
    }

    @Shadow
    private static void m_34860_(Piglin p_34861_, List<ItemStack> p_34862_) {
        throw new IllegalStateException();
    }
}

