/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.config;

import com.mrbysco.distantfriends.Constants;
import com.mrbysco.distantfriends.FriendNamesCache;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class FriendConfigForge {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOGGER.debug("Loaded Distant Friends' config file {}", (Object)configEvent.getConfig().getFileName());
        FriendNamesCache.refreshCache();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOGGER.debug("Distant Friends' config just got changed on the file system!");
        FriendNamesCache.refreshCache();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> friends;
        public final ForgeConfigSpec.BooleanValue addWhitelistPlayers;
        public final ForgeConfigSpec.BooleanValue playerMobsCompat;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> playerMobsNameLinks;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Friends").push("friends");
            this.friends = builder.comment("A list of users who can be chosen when it spawns a distant friend").defineListAllowEmpty("friends", List.of("darkosto"), o -> o instanceof String);
            this.addWhitelistPlayers = builder.comment("Add the players from the whitelist to the Friends list [default: true]").define("addWhitelistPlayers", true);
            builder.pop();
            builder.comment("Compat").push("compat");
            this.playerMobsCompat = builder.comment("Add players from a Player Mobs whitelist to the Friends list [default: false]").define("playerMobsCompat", false);
            this.playerMobsNameLinks = builder.comment("The player mobs Name Links, must start with https://whitelist.gorymoon.se").defineListAllowEmpty(List.of("playerMobsNameLinks"), List.of(), o -> {
                String string;
                return o instanceof String && (string = (String)o).startsWith("https://whitelist.gorymoon.se");
            });
            builder.pop();
        }
    }
}

